#include "mbed.h"
#include "QuadDisplay2.h"
#include "ESP_8266.h"
///Definitions
#define TICKER_PERIOD 20
const int buffer_size = 255;    
typedef struct {
    volatile uint8_t in;
    uint8_t event;      
    uint8_t app;
    uint8_t answer; 
    char buffer[buffer_size];  
  } RxPc;

////Global variables                                                                             
uint8_t button_cnt;
uint8_t button_event;
uint8_t prox1;
uint8_t prox2;
uint8_t prox1_event;
uint8_t prox2_event; 
uint8_t ind_en;
uint8_t button_cnt_prev = button_cnt;
RxPc rxpc;
char tx_buffer[128];
uint8_t PC_exist=0, WIFI_exist=0;



//Interface                                                                                     

DigitalOut led1(LED1);
InterruptIn button1(USER_BUTTON);
DigitalOut relay1(D12);
DigitalOut relay2(D9);
DigitalOut relay3(D8);
DigitalOut relay4(D11);
InterruptIn proximity1(D5);
InterruptIn proximity2(D7);
SPI spi(D4, D5, D3);
QuadDisplayMy display(&spi,D6); 
Serial pc(USBTX, USBRX);
PinName wifitx=PB_6, wifirx=PB_7, wifics=PC_0, Nled=LED1;


/////////
///Prototypes
void button1_enabled_cb(void);
void button1_onpressed_cb(void);
void Ini();
void button_frame_timeout_isr()
{
    button_event=button_cnt;
    button_cnt=0;    
}    
 void HowManyClicks()
{
 if(button_event){
    switch (button_event){
        case 1:
            relay1=!relay1; 
            break;
        case 2:
            relay2=!relay2;               
            break; 
        case 3:
            relay3=!relay3;              
            break;
        case 4:
            relay4=!relay4;           
            break;
        case 5:
            relay1=relay2=relay3= relay4=0;
        default:
            break;                                                                                                   
    }     
    button_event=0;            
 }                             
}   
    




/////////


/////////////////////////
///Time       
Timeout button_frame_timeout;                                                                         
Timeout button1_timeout;
Ticker IndTicker;



 // Used for debouncing
//////////////////////////////////
/***********************************************************
*                               Interrupt Service Routines 
                                      *
/***********************************************************/
void IndTicker_isr()
{
    ind_en=1;    
}
void proximity1_0_isr()
{
  prox1_event=1; 
  prox1=0;
}    
void proximity2_0_isr()
{
  prox2_event=1; 
  prox2=0;
}       
//--------------------------
void proximity1_1_isr()
{
  prox1=1;    
}
//--------------------------   
void proximity2_1_isr()
{
 prox2=1;    
}




volatile bool button1_pressed = false; // Used in the main loop
volatile bool button1_enabled = true; // Used for debouncing


// Enables button when bouncing is over
void button1_enabled_cb(void)
{
    button1_enabled = true;
}

// ISR handling button pressed event
void button1_onpressed_cb(void)
{
    if (button1_enabled) { // Disabled while the button is bouncing
        button1_enabled = false;
        button1_pressed = true; // To be read by the main loop
        button1_timeout.attach(callback(button1_enabled_cb), 0.3); // Debounce time 300 ms
    }
}

int main()
{
    //button1.mode(PullUp); // Activate pull-up
    button1.fall(callback(button1_onpressed_cb)); // Attach ISR to handle button press event


    int idx = 0; // Just for printf below

    while(1) {
       HowManyClicks();
        }
    }
void Rx_interrupt()
{
    while(pc.readable()) {
        rxpc.buffer[rxpc.in] = pc.getc();
        if ((rxpc.buffer[rxpc.in] =='\n')||(rxpc.buffer[rxpc.in]>128)){
            rxpc.event=1;
            rxpc.in = (rxpc.in + 1) % buffer_size;
        } else if(rxpc.event==0)
            rxpc.in = (rxpc.in + 1) % buffer_size;
    }
} 



/************************************************************
*                         CALLBACK                                                                     *
************************************************************/
//---5
void pc_printfCallback(char *buffer)
{
  pc.printf("%s",buffer);
}    
//--------------------------------------------------
void ResponseWiFiCallback(char *data,uint8_t answer)
{
 Respons(answer,data);
 if(data[0]=='0')
    rxwifi.answer=0; 
}
//-----------------------------------------
 uint8_t wifi_executeCallback(char *buffer)
{   
   WIFI_exist=1;
   PC_exist=0; 
   return execute(buffer);
}


////Functions                                                        
/***********************************************************/
void Ini()
{ 
    //button1.mode(PullUp); // Activate pull-up
    button1.fall(callback(button1_onpressed_cb)); // Attach ISR to handle button press event 
    relay1=relay2=relay3= relay4=0;  
    proximity1.rise(callback(proximity1_1_isr));  
    proximity1.fall(callback(proximity1_0_isr));        
    proximity2.fall(callback(proximity2_0_isr)); 
    proximity2.rise(callback(proximity2_1_isr));  
    IndTicker.attach_us(&IndTicker_isr, TICKER_PERIOD*1000);
    pc.baud(115200);
    pc.attach(&Rx_interrupt, Serial::RxIrq);

}
void actions()
{
    if(prox1_event){
        if(relay1==0){ 
            relay1=1; 
            relay2=1;
    }else{
            relay1=0;
            relay2=0;              
        } 
        prox1_event=0;
    }  
    if(prox2_event){
        if (relay3==0){
            relay3=1;
            relay4=1; 
        }else{
            relay3=0;
            relay4=0;               
        }
        prox2_event=0;                       
    }          
}

void indication()  
{
    if (ind_en){
        ind_en=0; 
        if(button_cnt_prev!=button_cnt){
            char text[5];
            uint8_t b;
            if (button_cnt){
                sprintf(text,"P%1d  ",button_cnt); 
                b=button_cnt;
            }else
                b=button_cnt_prev;
            text[2]=3;
            text[3]=3;                          
            switch (b){        
                case 1:
                    text[2]=2; 
                    text[3]=relay1?'1':'0';
                    break;
                case 2:
                    text[2]=2;                 
                    text[3]=relay2?'1':'0';
                    break; 
                case 3:
                    text[2]=2;                 
                    text[3]=relay3?'1':'0';
                    break;  
                case 4:
                    text[2]=2;                 
                    text[3]=relay4?'1':'0';
                    break;  
                case 5:
                    for(int i=0;i<4;i++)
                        text[i]=5; 
                    break;  
                default:
                    break;                                                                                                                                             
            }                                      
            display.displayDigits((uint8_t*)text); 
        } 
        button_cnt_prev=button_cnt;    
   }    
}         
  uint8_t execute(char *buffer)
{
  char *endptr;
  uint8_t answer;
  
    answer=0;
    switch(buffer[0]) {
        case 'k': 
            endptr=strstr(&buffer[0],"k1");  
            if(endptr!=NULL){
                endptr +=2;
                if(endptr[0]=='1')
                  relay1=1;
                else
                  relay1=0;                    
            }  
            endptr=strstr(&buffer[0],"k2");  
            if(endptr!=NULL){
                endptr +=2;
                if(endptr[0]=='1')
                  relay2=1;
                else
                  relay2=0;                    
            } 
            endptr=strstr(&buffer[0],"k3");  
            if(endptr!=NULL){
                endptr +=2;
                if(endptr[0]=='1')
                  relay3=1;
                else
                  relay3=0;                    
            }   
            endptr=strstr(&buffer[0],"k4");  
            if(endptr!=NULL){
                endptr +=2;
                if(endptr[0]=='1')
                  relay4=1;
                else
                  relay4=0;                    
            }    
            endptr=strstr(&buffer[0],"k0");  
            if(endptr!=NULL){
                endptr +=2;
                if(endptr[0]=='1'){
                  relay1=relay2=relay3= relay4=1;
                
                }else{
                  relay1=relay2=relay3= relay4=0;
                }                     
            }                                                                                         
            break;  
        case 'S':
        case 's':
            answer=1;
            break;                         
    }  
    return answer;   
}   

void Respons(uint8_t answer,char* tbuff)
{
        switch(answer) {
            case 1:
              sprintf(tbuff,
                "P1=%1d P2=%1d L1...L4=%1d %1d %1d %1d\r\n",
                prox1,prox2,
                relay1?1:0,relay2?1:0,relay3?1:0,relay4?1:0);    
                break;
            case 2:
                break;            
            case 3:
                break;
            case 4:
                break;
         }                       
void PcDataProcessing();
{
  if(rxpc.event){    
    switch(rxpc.buffer[0]) {
        case 'P': //------wifi sleep
        case 'p':
            break;
        case 'W': //------wifi wake up
        case 'w':
            break;
        case 'A': //----------AT commands-------------
            //if(CH_PD)
            //    WriteWiFi((uint8_t *)rxpc.buffer,rxpc.in);
            break;
        default:
            //PC_exist=1;
            //WIFI_exist=0; 
            rxpc.answer=execute(rxpc.buffer);
            if (rxpc.answer==0)
               pc.printf("%s",rxpc.buffer);
             else{
                Respons(rxpc.answer,tx_buffer); 
                pc.printf("%s",tx_buffer);                 
             }  
    }
    rxpc.in =0;
    rxpc.event=0;
  }  
}

                
} 






