#ifndef NEIGHBOURHOOD_H
#define NEIGHBOURHOOD_H

#include <list>
#include "hci.h"

//#define STRICT_MRU

/******************************************************************************************
call 'read' as part of the startup
on HCI_READ-STORED-LINK-KEY -COMPLETED event,  call 'set_cap'
on RETURN_LINK_KEYS_EVENT call 'add' for each key with init=true
on LINK_KEY_NOTIFICATION_EVENT call 'add' with init=false (default)
on LINK_KEY_REQUEST_EVENT call 'get' and send the proper reply
call 'write' as part of shutdown

a simpler approach could be to check for a link if it exists (single read) and try to add it.
when it fails just delete all.
********************************************************************************************/

#define HCI_DELETE_STORED_LINK_KEY  0x0C12
#define HCI_WRITE_STORED_LINK_KEY   0x0C11
#define HCI_READ_STORED_LINK_KEY    0x0C0D

void printf(const BD_ADDR* addr);

class neighbourhood {
    static const int lksize = 16;
    struct item {
        BD_ADDR a;
        unsigned char lk[lksize];
        bool used;
        item (BD_ADDR *ad, const unsigned char *k, bool d) {
            memcpy(&a, ad, sizeof(BD_ADDR));
            memcpy(lk, k, lksize);
            used=d;
        }
    };
    int cap, initsize, used;
    list<item> keys;
    bool dirty;
    HCI *hci;
    void delete_link_key(BD_ADDR *a) {
        unsigned char param[sizeof(BD_ADDR)+1];
        memcpy(param, a, sizeof(BD_ADDR));
        param[sizeof(BD_ADDR)] = 0;
        hci->SendCmd(HCI_DELETE_STORED_LINK_KEY, param, sizeof(param));
    }
    void write_link_keys(unsigned char param[]) {
        hci->SendCmd(HCI_WRITE_STORED_LINK_KEY, param, param[0]*(sizeof(BD_ADDR)+lksize)+1);
    }
public:
    neighbourhood(HCI *h): hci(h) {
        dirty = false;
        used = 0;
        cap=0;
        initsize=0;
    }
    void read() {
        unsigned char param[sizeof(BD_ADDR)+1];
        memset(param, 0, sizeof(BD_ADDR));
        param[sizeof(BD_ADDR)] = 1;
        hci->SendCmd(HCI_READ_STORED_LINK_KEY, param, sizeof(param));
    }
    void write();
    void set_cap(int c, int s) {
        cap = c;
        initsize = s;
        printf("Neighbourhood: capacity=%d, used=%d\n", c, s);
    }
    int get(BD_ADDR *a, unsigned char *key);
    int add(BD_ADDR *a, const unsigned char *key, bool init=false);
};

extern neighbourhood *neighbors;

#endif