/*
  RN-42XVPによるRFCOMM通信のサンプルプログラム（mbed側）
    ・受け取った電文の1-4ビット目でLPC1768のLED1-4を点灯・消灯させる

RN-42XVP   LPC1768
-------------------
Pin1       VOUT
Pin2       p14(rx) or p10
Pin3       p13(tx) or p9
Pin10      GND   
*/
#include "mbed.h"

BusOut leds(LED1, LED2, LED3, LED4);
Serial pc(USBTX, USBRX); // For Debug
Serial xbee(p9, p10);    // RN-42XVP

int main()
{
    uint8_t rawData;
 
    xbee.baud(115200);

    while(1) {
        if (xbee.readable() == 1) {
            rawData = xbee.getc();
            pc.printf("rawData = %02x\n", rawData);
            if (rawData <= 0x0f) {
                leds = rawData;
            }
        }
    }
}
