#ifndef SENSOR_HANDLER_H
#define SENSOR_HANDLER_H

#include <HTTPRequestHandler.h>

class SensorHandler : public HTTPRequestHandler
{
public:
  SensorHandler(const char* rootPath, const char* path, TCPSocket* pTCPSocket);
  virtual ~SensorHandler();

  static inline HTTPRequestHandler* inst(const char* rootPath, const char* path, TCPSocket* pTCPSocket) { return new SensorHandler(rootPath, path, pTCPSocket); } //if we ever could do static virtual functions, this would be one

  virtual void doGet();
  virtual void doPost();
  virtual void doHead();
  
  virtual void onReadable(); //Data has been read
  virtual void onWriteable(); //Data has been written & buf is free
  virtual void onClose(); //Connection is closing
  
private:
  void printString( const char* pszString );
};

#endif
