#include "SensorHandler.h"

//#define __DEBUG
#include <dbg.h>

AnalogIn g_ain_brightness(p15);
AnalogIn g_ain_temperature(p20);

SensorHandler::SensorHandler(const char* rootPath, const char* path, TCPSocket* pTCPSocket) : HTTPRequestHandler(rootPath, path, pTCPSocket)
{
    DBG("SensorHandler()\r\n");
}

SensorHandler::~SensorHandler()
{
    DBG("~SensorHandler()\r\n");
}
void SensorHandler::printString( const char* pszString )
{
    writeData( pszString, strlen(pszString) );
}

double GetTemperature()
{
    double dV = g_ain_temperature * 3.3;
    return dV * 100.0;
}

int GetBrightness()
{
    double dV = g_ain_brightness * 3.3;
    
    double dR = 0.0;
    if( 0.005 < (3.3 - dV) )
    {
        dR = 10 * 1000 * dV / (3.3 - dV);
    }
    
    if( 100000.0 < dR )
    {
        return 0;
    }
    if( 4000.0 > dR )
    {
        return 2;
    }
    return 1;
}

void SensorHandler::doGet()
{
    DBG("doGet()\r\n");

    respHeaders()["Connection"] = "close";
    
    printString( "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\">\n" );
    printString( "<html lang=\"ja\">\n" );
    printString( "<head>\n" );
    printString( "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n" );
    printString( "<meta http-equiv=\"Content-Style-Type\" content=\"text/css\">\n" );
    printString( "<title></title>\n" );
    printString( "</head>\n" );
    printString( "<body>\n" );
    
    printString( "Temperature : " );
    char szTemperature[10];
    sprintf( szTemperature, "%4.1f", GetTemperature() );
    printString( szTemperature );
    printString( " [degree]\n" );
    printString( "<br /><br />\n" );

    printString( "Brightness : "); 
    switch( GetBrightness() )
    {
    case 0:
        printString("Dark");
        break;
    case 1:
        printString("Ordinarily");
        break;
    case 2:
        printString("Bright");
        break;
    }
    printString( "<br />\n" );

    printString( "</body>\n" );
    printString( "</html>" );
}

void SensorHandler::doPost()
{
    DBG("doPost()\r\n");
}

void SensorHandler::doHead()
{
    DBG("doHead()\r\n");
}
  
void SensorHandler::onReadable() //Data has been read
{
    DBG("onReadable()\r\n");
}

void SensorHandler::onWriteable() //Data has been written & buf is free
{
    DBG("onWriteable()\r\n");
    close(); //Data written, we can close the connection
}

void SensorHandler::onClose() //Connection is closing
{
    DBG("onClose()\r\n");
}
