#include "mbed.h"

#define DEBOUNCEDELAY 500

// Turn ON/OFF the power of TV
int ARRAY_HIGHLOW[] = { 
 3507, 1686, 493, 400, 469, 1242, 494, 375, 493, 375, 494, 375, 493, 399, 469, 400, 469, 399, 469, 375,
 494, 399, 469, 375, 493, 373, 496, 373, 495, 1268, 468, 377, 492, 399, 469, 400, 469, 373, 495, 399,
 469, 400, 469, 399, 469, 373, 495, 400, 469, 1268, 468, 400, 469, 399, 469, 400, 468, 374, 495, 399,
 469, 400, 468, 374, 495, 400, 468, 1268, 469, 400, 468, 1268, 469, 1243, 494, 1268, 468, 1268, 469, 400,
 468, 375, 494, 1268, 468, 400, 469, 1243, 493, 1245, 492, 1268, 469, 1268, 468, 400, 469, 1243, 493, 74551,
 3533, 1685, 494, 375, 493, 1268, 469, 374, 494, 400, 469, 399, 469, 399, 469, 376, 493, 372, 496, 399,
 469, 400, 469, 376, 492, 399, 469, 400, 469, 1267, 469, 400, 469, 399, 469, 373, 495, 400, 469, 399,
 469, 400, 468, 400, 469, 399, 469, 400, 468, 1268, 469, 400, 468, 376, 493, 374, 494, 400, 468, 400,
 468, 377, 492, 400, 468, 400, 469, 1245, 492, 399, 469, 1243, 494, 1268, 468, 1269, 468, 1268, 421, 447,
 469, 376, 492, 1245, 444, 425, 491, 1269, 420, 1316, 421, 1293, 491, 1269, 468, 377, 491, 1244, 445, 74608,
 3508, 1710, 469, 399, 469, 1268, 469, 399, 469, 399, 469, 400, 469, 399, 469, 399, 469, 400, 469, 375,
 493, 399, 469, 400, 469, 373, 495, 373, 495, 1268, 469, 399, 469, 400, 469, 399, 469, 400, 468, 373,
 496, 399, 469, 400, 468, 375, 494, 399, 469, 1268, 469, 400, 468, 400, 468, 400, 469, 400, 468, 400,
 468, 400, 469, 400, 468, 374, 494, 1269, 468, 400, 469, 1268, 468, 1243, 494, 1268, 469, 1268, 468, 400,
 469, 400, 468, 1268, 469, 376, 492, 1269, 468, 1268, 469, 1268, 468, 1244, 493, 400, 468, 1242, 495, };

                            
DigitalIn g_digitalinButton(p20);
PwmOut g_pwmoutLed(p21);

void sendSignal()
{
    g_pwmoutLed.period_us( 26 );   // 38KHz => 1/38000[s] = 26.315 * 10 ^ -6 [s] = 26.315 [us]

    int iCountHighLow = sizeof( ARRAY_HIGHLOW ) / sizeof( ARRAY_HIGHLOW[0] );
    for( int iIndexHighLow = 0; iIndexHighLow < iCountHighLow; iIndexHighLow++ )
    {
        g_pwmoutLed.write( 0.5 * (1 - (iIndexHighLow % 2)) );    // iIndexHighLow : even number -> 0.5, uneven number -> 0
        wait_us( ARRAY_HIGHLOW[iIndexHighLow] );
    }
}

int main()
{
    Timer timer;
    timer.start();
    int iMilliSec_prev = timer.read_ms();
    int iButtonState_prev = 0;
    
    while(1)
    {
        int iButtonState = g_digitalinButton;
        
        if( 0 == iButtonState_prev
         && 1 == iButtonState )
        {
            int iMilliSec = timer.read_ms();
            if( DEBOUNCEDELAY < (iMilliSec - iMilliSec_prev) )
            {
                sendSignal();
            }

            iMilliSec_prev = iMilliSec;
        }

        iButtonState_prev = iButtonState;
    }
}
