#include "mbed.h"

DigitalIn g_digitalinIrReceiver(p20);
Serial g_serial(USBTX, USBRX);

int main()
{
    // デジタル入力ピンは、デフォルトで、内部プルダウンとなります（参考：https://developer.mbed.org/handbook/DigitalIn）
    // 内部プルダウンの場合、IRセンサーからのHIGH電圧をLOW電圧と検知してしまうので、内部プルモードを「プルなし(PullNone)」にします。
    g_digitalinIrReceiver.mode( PullNone ); // mode : PullUp, PullDown, PullNone, OpenDrain
    g_serial.baud(115200);

    Timer timer;
    timer.start();
    int iMicroSec_prev = timer.read_us();
    int iState_prev = 1;
    while(1)
    {
        int iState = g_digitalinIrReceiver;
        if( iState != iState_prev )
        {
            iState_prev = iState;
            int iMicroSec = timer.read_us();
            g_serial.printf( "%d, ", iMicroSec - iMicroSec_prev );
            iMicroSec_prev = iMicroSec;
        }
    }
}
