#include "PostHandler.h"

//#define __DEBUG
#include <dbg.h>

#define DELIMITER   ("&")

extern bool g_bLed1;
extern bool g_bLed2;
extern bool g_bLed3;
extern int g_iSpeed;
extern double g_dInterval;

AnalogIn g_ain_brightness(p15);
AnalogIn g_ain_temperature(p20);

PostHandler::PostHandler(const char* rootPath, const char* path, TCPSocket* pTCPSocket) : HTTPRequestHandler(rootPath, path, pTCPSocket)
{
    DBG("PostHandler()\r\n");
}

PostHandler::~PostHandler()
{
    DBG("~PostHandler()\r\n");
}
void PostHandler::printString( const char* pszString )
{
    writeData( pszString, strlen(pszString) );
}

void PostHandler::printHtml()
{
    respHeaders()["Connection"] = "close";

    printString("<html>");
    printString("<head>\n");
    printString("<title></title>\n");
    printString("</head>\n");
    printString("<body>\n");

    printString("<p>\n");
    printString("LED1 : "); printString( g_bLed1 ? "ON" : "off" ); printString("<br>\n");
    printString("LED2 : "); printString( g_bLed2 ? "ON" : "off" ); printString("<br>\n");
    printString("LED3 : "); printString( g_bLed3 ? "ON" : "off" ); printString("<br>\n");
    printString("<br>\n");
    printString("Speed: \n");
    char szSpeed[10];
    sprintf( szSpeed, "%d", g_iSpeed );
    printString( szSpeed );
    printString("</p>\n");

    printString("<hr>\n");

    printString("<form method=\"post\" action=\"\">\n");
    printString("<label><input type=\"checkbox\" name=\"led1\" value=\"1\""); if(g_bLed1){ printString(" checked"); } printString(">LED1</label><br><br>\n");
    printString("<label><input type=\"checkbox\" name=\"led2\" value=\"1\""); if(g_bLed2){ printString(" checked"); } printString(">LED2</label><br><br>\n");
    printString("<label><input type=\"checkbox\" name=\"led3\" value=\"1\""); if(g_bLed3){ printString(" checked"); } printString(">LED3</label><br><br>\n");
    printString("Speed<br>\n");
    printString("<label><input type=\"radio\" name=\"speed\" value=\"1\""); if(1==g_iSpeed){ printString(" checked"); } printString("> 1 </label> \n");
    printString("<label><input type=\"radio\" name=\"speed\" value=\"2\""); if(2==g_iSpeed){ printString(" checked"); } printString("> 2 </label> \n");
    printString("<label><input type=\"radio\" name=\"speed\" value=\"3\""); if(3==g_iSpeed){ printString(" checked"); } printString("> 3 </label> \n");
    printString("<label><input type=\"radio\" name=\"speed\" value=\"4\""); if(4==g_iSpeed){ printString(" checked"); } printString("> 4 </label> \n");
    printString("<label><input type=\"radio\" name=\"speed\" value=\"5\""); if(5==g_iSpeed){ printString(" checked"); } printString("> 5 </label> \n");
    printString("<label><input type=\"radio\" name=\"speed\" value=\"6\""); if(6==g_iSpeed){ printString(" checked"); } printString("> 6 </label> \n");
    printString("<label><input type=\"radio\" name=\"speed\" value=\"7\""); if(7==g_iSpeed){ printString(" checked"); } printString("> 7 </label> \n");
    printString("<label><input type=\"radio\" name=\"speed\" value=\"8\""); if(8==g_iSpeed){ printString(" checked"); } printString("> 8 </label> \n");
    printString("<label><input type=\"radio\" name=\"speed\" value=\"9\""); if(9==g_iSpeed){ printString(" checked"); } printString("> 9 </label> \n");
    printString("<br>\n");
    printString("<br>\n");
    printString("<br>\n");
    printString("<input type=\"submit\" value=\"Send\">\n");
    printString("</form>\n");

    printString("</body>\n");
    printString("</html>");
}

void PostHandler::doGet()
{
    DBG("doGet()\r\n");

    printHtml();
}

static void analyzePostData( char* pszLine, bool& rbLed1, bool& rbLed2, bool& rbLed3, int& riSpeed )
{
    rbLed1 = false;
    rbLed2 = false;
    rbLed3 = false;
    riSpeed = 5;
    char* pszToken = strtok(pszLine, DELIMITER);
    while(pszToken)
    {
        if( 6 == strlen(pszToken)
         && 0 == strncmp(pszToken, "led", 3) )
        {   // led?=1
            if(      '1' == pszToken[3] ){ rbLed1 = true; }
            else if( '2' == pszToken[3] ){ rbLed2 = true; }
            else if( '3' == pszToken[3] ){ rbLed3 = true; }
        }
        else if( 7 == strlen(pszToken)
         && 0 == strncmp(pszToken, "speed", 5) )
        {   // speed=?
            riSpeed = pszToken[6] - '0';
        }
        pszToken = strtok(NULL, DELIMITER);
    }
}

void PostHandler::doPost()
{
    DBG("doPost()\r\n");

    int iCountData = dataLen();
    if( 0 == iCountData )
    {
            printHtml();
            return;
    }
    
    char* pszData = (char*) malloc( sizeof(char) * (iCountData + 1) );
    readData( pszData, iCountData );
    pszData[iCountData] = '\0';
    
    DBG( pszData );
    
    bool bLed1, bLed2, bLed3;
    int iSpeed;
    analyzePostData( pszData, bLed1, bLed2, bLed3, iSpeed );
    g_bLed1 = bLed1;
    g_bLed2 = bLed2;
    g_bLed3 = bLed3;
    g_iSpeed = iSpeed;
    g_dInterval = 0.5 + (g_iSpeed - 1) * (0.01 - 0.5) / (9 - 1);

    printHtml();
}

void PostHandler::doHead()
{
    DBG("doHead()\r\n");
}
  
void PostHandler::onReadable() //Data has been read
{
    DBG("onReadable()\r\n");
}

void PostHandler::onWriteable() //Data has been written & buf is free
{
    DBG("onWriteable()\r\n");
    close(); //Data written, we can close the connection
}

void PostHandler::onClose() //Connection is closing
{
    DBG("onClose()\r\n");
}
