#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"

#include "PostHandler.h"

EthernetNetIf ethif( IpAddr(192,168,1,102), // IP
                     IpAddr(255,255,255,0), // Subnet mask
                     IpAddr(192,168,1,1),   // Gateway
                     IpAddr(192,168,1,1) ); // DNS
HTTPServer server;
DigitalOut ledAliveCheck(LED1);  // for alive check

DigitalOut led1(p21);
DigitalOut led2(p22);
DigitalOut led3(p23);

bool g_bLed1 = false;
bool g_bLed2 = false;
bool g_bLed3 = false;
int g_iSpeed = 5;
double g_dInterval = 0.5 + (g_iSpeed - 1) * (0.01 - 0.5) / (9 - 1);
bool g_bHighLow = false;

int main(void)
{
    // EthernetNetIf setup
    if( ethif.setup() )
    {
        return 1;
    }

    // Set web root path handler
    server.addHandler<PostHandler>("/");
    
    // Set http port
    server.bind(80);
    

    Timer tmAliveCheck;
    Timer tmLed;
    tmAliveCheck.start();
    tmLed.start();
    
    while(1)
    {
        Net::poll();
        if( 1.0 < tmAliveCheck.read() )
        {
            ledAliveCheck = !ledAliveCheck;   // high->low, low->high
            tmAliveCheck.start();
        }
        if( g_dInterval < tmLed.read() )
        {
            g_bHighLow = !g_bHighLow;
            if( g_bLed1 ){ led1 = g_bHighLow; } else { led1 = false; }
            if( g_bLed2 ){ led2 = g_bHighLow; } else { led2 = false; }
            if( g_bLed3 ){ led3 = g_bHighLow; } else { led3 = false; }
            tmLed.start();
        }
    }
}