#include "mbed.h"
#include "TextLCD.h"

TextLCD g_lcd(p24, p26, p27, p28, p29, p30);  // RS, E, DB4, DB5, DB6, DB7
AnalogIn g_analogin(p15);

int main() {
    wait(0.001);
    g_lcd.cls(); wait(0.001);
    g_lcd.locate(0, 0);

    while(1) {
        double dV = g_analogin * 3.3;
        
        double dR = 0.0;
        if( 0.005 < (3.3 - dV) )
        {
            dR = 10 * 1000 * dV / (3.3 - dV);
        }
        
        g_lcd.cls(); wait(0.001);
        g_lcd.locate(0, 0);
        g_lcd.printf( "%5.2lf[V]", dV );
        g_lcd.locate(0, 1);
        if( 0.0 == dR )
        {
            g_lcd.printf( "Infinity[ohm]" );
        }
        else
        {
            g_lcd.printf( "%8.2lf[ohm]", dR );
        }
        
        wait(1.0);
    }
}
