#ifndef REMOTECONTROLLER_HANDLER_H
#define REMOTECONTROLLER_HANDLER_H

#include <HTTPRequestHandler.h>

class RemoteControllerHandler : public HTTPRequestHandler
{
public:
  RemoteControllerHandler(const char* rootPath, const char* path, TCPSocket* pTCPSocket);
  virtual ~RemoteControllerHandler();

  static inline HTTPRequestHandler* inst(const char* rootPath, const char* path, TCPSocket* pTCPSocket) { return new RemoteControllerHandler(rootPath, path, pTCPSocket); } //if we ever could do static virtual functions, this would be one

  virtual void doGet();
  virtual void doPost();
  virtual void doHead();
  
  virtual void onReadable(); //Data has been read
  virtual void onWriteable(); //Data has been written & buf is free
  virtual void onClose(); //Connection is closing
  
private:
  void printString( const char* pszString );
  void printHtml( int iSignalType/* = 0*/, int iIsCorrectPassCode/* = 0*/ );
};

#endif
