#include "RemoteControllerHandler.h"

//#define __DEBUG
#include <dbg.h>

#define CHECK_PASSCODE

#define DELIMITER   ("&")
#define PASSCODE    (170)   // 1357 : 010101010

// Turn ON the power of Air Conditioner
short ARRAY_HIGHLOW_ON[] = { 5067, 2061, 389, 1730, 412, 631, 388, 658, 385, 656, 388, 1729, 413, 630, 389, 656, 387, 657, 387, 657,
                             385, 1732, 412, 630, 391, 1727, 414, 1703, 412, 631, 388, 1731, 411, 1707, 385, 1731, 386, 1729, 413, 1705,
                             388, 657, 388, 656, 387, 1730, 386, 656, 390, 654, 385, 660, 386, 657, 387, 656, 388, 656, 387, 1731,
                             411, 1707, 386, 1730, 411, 1705, 388, 1730, 388, 655, 388, 1732, 409, 1704, 412, 633, 388, 655, 414, 628,
                             390, 658, 384, 660, 385, 659, 384, 656, 414, 629, 389, 657, 386, 658, 386, 657, 385, 658, 387, 1730,
                             412, 1705, 389, 1729, 409, 1707, 388, 656, 387, 655, 414, 629, 390, 657, 385, 29221, 5067, 2062, 413, 1704,
                             388, 655, 389, 657, 387, 656, 412, 1706, 386, 658, 385, 657, 412, 632, 387, 658, 385, 1729, 391, 655,
                             386, 1729, 413, 1705, 388, 657, 384, 1731, 414, 1706, 385, 1733, 409, 1707, 385, 1731, 411, 631, 388, 658,
                             385, 1730, 414, 630, 389, 656, 386, 658, 412, 630, 388, 658, 384, 659, 410, 630, 389, 658, 386, 659,
                             410, 630, 389, 1732, 410, 1704, 388, 658, 385, 655, 414, 1705, 389, 655, 386, 1730, 414, 1703, 388, 1731,
                             409, 633, 387, 659, 385, 660, 409, 630, 387, 660, 385, 1731, 386, 660, 383, 1731, 388, 655, 388, 658,
                             386, 657, 411, 631, 388, 658, 384, 1731, 413, 631, 389, 657, 384, 659, 410, 632, 384, 662, 358, 685,
                             386, 657, 386, 658, 385, 657, 412, 633, 386, 659, 382, 711, 360, 631, 388, 684, 358, 661, 409, 632,
                             386, 660, 383, 658, 388, 656, 387, 1732, 411, 1704, 387, 1732, 409, 632, 388, 659, 383, 658, 411, 631,
                             388, 1732, 386, 656, 388, 1731, 410, 633, 386, 660, 383, 658, 387, 657, 387, 659, 383, 684, 386, 634,
                             385, 1732, 408, 633, 385, 661, 358, 685, 408, 634, 386, 1732, 387, 656, 387, 1731, 386, 656, 387, 1733,
                             409, 632, 387, 659, 384, 1731, 411,};
// Turn OFF the power of Air Conditioner
short ARRAY_HIGHLOW_OFF[] = { 5067, 2063, 411, 1706, 387, 658, 386, 656, 388, 656, 388, 1730, 411, 631, 389, 657, 386, 658, 385, 658,
                             386, 1729, 413, 631, 388, 1730, 388, 1730, 411, 631, 389, 1729, 388, 1728, 413, 1704, 388, 1732, 385, 1731,
                             411, 631, 389, 656, 386, 1730, 412, 631, 388, 657, 389, 655, 389, 654, 389, 655, 386, 658, 409, 1708,
                             386, 1730, 412, 1706, 410, 1708, 386, 1730, 412, 631, 388, 1730, 386, 1731, 387, 657, 389, 655, 386, 657,
                             410, 634, 384, 659, 386, 658, 387, 655, 389, 655, 388, 657, 387, 657, 386, 658, 385, 660, 385, 1730,
                             387, 1730, 411, 1705, 388, 1730, 387, 657, 388, 655, 388, 656, 386, 658, 408, 29198, 5067, 2062, 412, 1705,
                             389, 656, 389, 655, 437, 605, 386, 1731, 413, 631, 412, 632, 387, 658, 411, 632, 386, 1732, 411, 631,
                             388, 1729, 412, 1705, 388, 656, 386, 1731, 412, 1705, 386, 1731, 411, 1705, 388, 1733, 410, 631, 388, 658,
                             385, 1729, 412, 632, 389, 656, 386, 657, 412, 631, 388, 657, 385, 657, 414, 628, 391, 656, 388, 656,
                             412, 630, 386, 1732, 410, 1705, 389, 659, 384, 658, 411, 1705, 388, 656, 387, 1730, 411, 1705, 388, 658,
                             384, 659, 412, 630, 388, 658, 385, 657, 412, 631, 389, 1730, 411, 631, 387, 1729, 413, 632, 387, 660,
                             383, 659, 409, 634, 385, 660, 384, 1730, 412, 632, 388, 657, 360, 683, 411, 632, 386, 659, 385, 659,
                             412, 628, 391, 656, 388, 656, 409, 633, 386, 659, 357, 689, 408, 632, 388, 659, 383, 656, 413, 631,
                             388, 658, 385, 682, 387, 633, 386, 1732, 412, 1703, 387, 1731, 410, 633, 386, 659, 386, 656, 414, 630,
                             388, 1754, 413, 605, 412, 1706, 411, 632, 387, 658, 385, 660, 410, 632, 385, 659, 385, 660, 411, 628,
                             389, 1730, 412, 632, 387, 658, 385, 659, 410, 632, 385, 660, 386, 658, 412, 1703, 386, 659, 385, 1731,
                             388, 656, 386, 657, 411, 1707, 386, };

AnalogIn g_ain_temperature(p16);
PwmOut g_pwmout(p21);

RemoteControllerHandler::RemoteControllerHandler(const char* rootPath, const char* path, TCPSocket* pTCPSocket) : HTTPRequestHandler(rootPath, path, pTCPSocket)
{
    DBG("RemoteControllerHandler()\r\n");
}

RemoteControllerHandler::~RemoteControllerHandler()
{
    DBG("~RemoteControllerHandler()\r\n");
}
void RemoteControllerHandler::printString( const char* pszString )
{
    writeData( pszString, strlen(pszString) );
}

double GetTemperature()
{
    double dV = g_ain_temperature * 3.3;
    return dV * 100.0;
}

void RemoteControllerHandler::printHtml( int iSignalType = 0, int iIsCorrectPassCode = 0 )
{
    respHeaders()["Connection"] = "close";

    printString("<html>\n");
    printString("<head>\n");
    printString("<title>Net Remote Controller</title>\n");
    printString("</head>\n");
    printString("<body>\n");

    printString("<h1>Net Remote Controller</h1>\n");
    printString( "Temperature : " );
    char szTemperature[10];
    sprintf( szTemperature, "%4.1f", GetTemperature() );
    printString( szTemperature );
    printString( " [degree]\n" );

    printString("<hr>\n");

    if( 1 == iSignalType )
    {
        if( 0 == iIsCorrectPassCode )
        {
            printString("<p><font color=\"#ff0000\">PassCode is wrong.</font></p>\n");
        }
        else
        {
            printString("<p><font color=\"#008000\">ON signal was transmitted.</font></p>\n");
        }
    }
    else if( 2 == iSignalType )
    {
        if( 0 == iIsCorrectPassCode )
        {
            printString("<p><font color=\"#ff0000\">PassCode is wrong.</font></p>\n");
        }
        else
        {
            printString("<p><font color=\"#008000\">OFF signal was transmitted.</font></p>\n");
        }
    }
    else
    {
        printString("<p><font color=\"#0000ff\">Select the type of signal, enter the PassCode, please click the submit button</font></p>\n");
    }
    printString("<form method=\"post\" action=\"\">\n");
    printString("<h3>Type of signal</h3>\n");
    printString("<input type=\"radio\" name=\"signaltype\" value=\"0\" checked>None <input type=\"radio\" name=\"signaltype\" value=\"1\">On signal <input type=\"radio\" name=\"signaltype\" value=\"2\" >OFF signal <br>\n");
    printString("<h3>PassCode</h3>\n");
    printString("<input type=\"checkbox\" name=\"pc0\">0 <input type=\"checkbox\" name=\"pc1\">1 <input type=\"checkbox\" name=\"pc2\">2 <input type=\"checkbox\" name=\"pc3\">3 <input type=\"checkbox\" name=\"pc4\">4 <input type=\"checkbox\" name=\"pc5\">5 <input type=\"checkbox\" name=\"pc6\">6 <input type=\"checkbox\" name=\"pc7\">7<br>\n");
    printString("<br>\n");
    
    printString("<input type=\"submit\" value=\"submit\">\n");
    printString("</form>\n");

    printString("<hr>\n");
    printString("</body>\n");
    printString("</html>\n");
}

void RemoteControllerHandler::doGet()
{
    DBG("doGet()\r\n");

    printHtml();
}

void analyzePostData( char* pszLine, int& riSignalType, int& riPassCode )
{
    riSignalType = 0;
    riPassCode = 0;
    char* pszToken = strtok(pszLine, DELIMITER);
    while(pszToken)
    {
        if( 12 == strlen(pszToken)
         && 0 == strncmp(pszToken, "signaltype", 10) )
        {   // signaltype=0/1/2
            if(      '0' == pszToken[11] ){ riSignalType = 0; }
            else if( '1' == pszToken[11] ){ riSignalType = 1; }
            else if( '2' == pszToken[11] ){ riSignalType = 2; }
        }
        else if( 6 == strlen(pszToken)
        && 0 == strncmp(pszToken, "pc", 2) )
        {   // pc?=on
            riPassCode |= (1 << (pszToken[2] - '0'));
        }
        pszToken = strtok(NULL, DELIMITER);
    }
}

void sendSignal( int iSignalType )
{
    g_pwmout.period_us( 26 );   // 38KHz => 1/38000[s] = 26.315 * 10 ^ 6 [s] = 26.315 [us]

    short* aHighLow = NULL;
    int iCountHighLow = 0;
    if( 1 == iSignalType )
    {
        aHighLow = ARRAY_HIGHLOW_ON;
        iCountHighLow = sizeof( ARRAY_HIGHLOW_ON ) / sizeof( ARRAY_HIGHLOW_ON[0] );
    }
    else if( 2 == iSignalType )
    {
        aHighLow = ARRAY_HIGHLOW_OFF;
        iCountHighLow = sizeof( ARRAY_HIGHLOW_OFF ) / sizeof( ARRAY_HIGHLOW_OFF[0] );
    }
    
    if( NULL == aHighLow )
    {
        return;
    }
    
    DBG( "CountHighLow = % d\r\n", iCountHighLow );
    for( int iIndexHighLow = 0; iIndexHighLow < iCountHighLow; iIndexHighLow++ )
    {
        g_pwmout.write( 0.5 * (1 - (iIndexHighLow % 2)) );    // iIndexHighLow : even number -> 0.5, uneven number -> 0
        wait_us( aHighLow[iIndexHighLow] );
    }
}

void RemoteControllerHandler::doPost()
{
    DBG("doPost()\r\n");

    int iCountData = dataLen();
    if( 0 == iCountData )
    {
            printHtml();
            return;
    }
    
    char* pszData = (char*) malloc( sizeof(char) * (iCountData + 1) );
    readData( pszData, iCountData );
    pszData[iCountData] = '\0';
    
    DBG( pszData );
 
    int iSignalType = 0;
    int iPassCode = 0;
    analyzePostData( pszData, iSignalType, iPassCode );

#ifdef CHECK_PASSCODE
    // Check the PassCode
    int iIsCorrectPassCode = 0;
    if( PASSCODE == iPassCode )
    {
        iIsCorrectPassCode = 1;
    }
    // Send Signal
    if( 1 == iIsCorrectPassCode )
    {
        sendSignal( iSignalType );
    }
#else
    int iIsCorrectPassCode = 1;
    sendSignal( iSignalType );
#endif

    printHtml( iSignalType, iIsCorrectPassCode );
}

void RemoteControllerHandler::doHead()
{
    DBG("doHead()\r\n");
}
  
void RemoteControllerHandler::onReadable() //Data has been read
{
    DBG("onReadable()\r\n");
}

void RemoteControllerHandler::onWriteable() //Data has been written & buf is free
{
    DBG("onWriteable()\r\n");
    close(); //Data written, we can close the connection
}

void RemoteControllerHandler::onClose() //Connection is closing
{
    DBG("onClose()\r\n");
}
