#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"

#include "RemoteControllerHandler.h"

EthernetNetIf ethif( IpAddr(192,168,1,102), // IP
                     IpAddr(255,255,255,0), // Subnet mask
                     IpAddr(192,168,1,1),   // Gateway
                     IpAddr(192,168,1,1) ); // DNS
HTTPServer server;
DigitalOut ledAliveCheck(LED1);  // for alive check

int main(void)
{
    // EthernetNetIf setup
    if( ethif.setup() )
    {
        return 1;
    }

    // Set web root path handler
    server.addHandler<RemoteControllerHandler>("/");
    
    // Set http port
    server.bind(80);
    

    Timer tmAliveCheck;
    tmAliveCheck.start();
    
    while(1)
    {
        Net::poll();
        if( 1.0 < tmAliveCheck.read() )
        {
            ledAliveCheck = !ledAliveCheck;   // high->low, low->high
            tmAliveCheck.start();
        }
    }
}