////////////////////////////////////////
//      Controlling Thorttle          //
//                                    //
////////////////////////////////////////
/* 
    Pingout:
    Nucleo-L432KC
    PA_0 ---> Analogin ---> Read Pedal sensor 1
    PA_1 ---> Analogin ---> Read Pedal sensor 2
    CANBUS:
    PA_11 ---> CANBUS TX
    PA_12 ----> CANBUS RX
*/

///////////////
// Libraries //
///////////////
#include <Map.hpp>
#include "mbed.h"
///////////////
// #defines  //
///////////////

/////////////
// Objects //
/////////////

//Pedal sensor and brake reading

AnalogIn analog_value1(PA_0);
AnalogIn analog_value2(PA_1);
AnalogIn analog_value3(PA_3);

//led indicator

DigitalOut myled(LED1);

// can bus

CAN can1(PA_11, PA_12);

//Serial

Serial pc(USBTX,USBRX);

//Timer

Timer t;

///////////////
// variables //
///////////////

int startup = 1;

//Sum counter
int counter = 0;

// Sending Counter
int  sendcounter = 0;

//Pedal error counter (0-1)

int errorcounter = 0;
// Error in pedal

int myerror = 0;

// pedal value (0-255)
int pdagree = 0;

// brake on or off

int mybrake = 0;

// pedal and brake value calculating variable

float pedal1, pedal2, sumpedal, subpedal, _mybrake;
float mypedal,sumPedal,sumBrake = 0;

// can message data initial values

char message_data[4] = {0,0,0,0}; 


//////////////////
//define Mapping//
//////////////////

Map mapvaltovolt = Map(0, 1, 0, 3300); // Maping Volt value from 0-1 to 0-3300
Map pedaltodagree = Map(900, 1260, 0, 255); // Maping Volt value from 860-1200 to 0 - 255


////////////////////
//functions///
////////////////////

// sending Data overcanbus

void sendData() { 
    message_data[0] = pdagree;
    message_data[1] = sendcounter;
    message_data[2] = myerror;
    message_data[3] = mybrake;
    //pc.printf("massage about sent %d", pdagree);
    if(can1.write(CANMessage(1337, message_data, 3))) {
        //pc.printf("error %d", message_data[2] );
        //pc.printf("Data %d\n", message_data[0] );
        //pc.printf("counter %d\n", message_data[1] );
        
        sendcounter++;
        if(sendcounter==255){
            sendcounter = 0;
            }
    }
}


void readSensors() { //reading Pedal and Brake sensors
    pedal1 = analog_value1.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    pedal2 = analog_value2.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    _mybrake = analog_value3.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    pedal1 = mapvaltovolt.Calculate(pedal1);
    pedal2 = mapvaltovolt.Calculate(pedal2);
    _mybrake = mapvaltovolt.Calculate(pedal1);
    
    //pc.printf("pedal1 is: %.4f, matzeret1 is:%.4f\n\r", pedal1, pedal2);
    sumpedal = pedal1+pedal2;
    //pc.printf("sumpedal is: %.4f\n\r", sumpedal);
    subpedal = abs(3400-sumpedal);
    //pc.printf("Subpedal is: %.4f\n\r", subpedal);
    if (subpedal<175) { //checking error
        mypedal = pedaltodagree.Calculate(pedal1);
        sumPedal = sumPedal + mypedal;
        sumBrake = sumBrake + _mybrake;
            if (t.read()>0) {
                t.stop();
                t.reset();
                errorcounter = 0;
                myerror = 0;
                }
        //pc.printf("setpedal dagree %.4f\n\r", pdagree);
        counter++;
        if (counter == 10) {
            pdagree = sumPedal/10;
            _mybrake = sumBrake/10;
            if (_mybrake>300) {
                mybrake = 1;
                }
            if (_mybrake>300) {
                mybrake = 0;
                }
            sendData();
            counter = 0;
            sumPedal = 0;
            sumBrake = 0;
        }
    }
    if (subpedal>175) {
        if (errorcounter == 0) {
            t.start();
            errorcounter = 1;
            }
        if (t.read() > 0.1) {
            t.stop();
            t.reset();
            myerror = 1;
            sendData();
            }
        }
}
int main() {
    while(1) {
        readSensors();
        }

}
