#include "stateMachine.h"
#include "serverSide.h"
#include "clientSide.h"
#include <string>

StateMachine::StateMachine(int placeInLoop, int totalInLoop){
    currentState = INIT;
    boardID = placeInLoop;
    maxBoards = totalInLoop;
    
}

StateMachine::~StateMachine(){
    
}

void StateMachine::start(){
    actionInit();
    while(true) {
        switch(currentState) {
            case INIT:
                actionInit();
                break;
            case CLIENT:
                actionClient();
                break;
            case SERVER:
                actionServer();
                currentState = CLIENT;
                break;
            default:
                currentState = CERROR;
                return;
        }
    }
    
}

void StateMachine::actionInit(){
    char answer;
    printf("What should this board serve as? Type 't' for transmittor or type 'r' for receiver: ");
    scanf("%c", &answer);
    if (answer == 't'){
        currentState = CLIENT;
        printf("\nYour board is serving as a TRANSMITTER on the CLIENT side!");
    }else {
        currentState = SERVER;
        printf("\nYour board is serving as a RECEIVER on the SERVER side!");
    }
}

void StateMachine::actionClient(){
    Client transmitter;
    char clientIP = ("192.168.0.%d", boardID);
    
}

void StateMachine::actionServer(){
    Server receiver;
    char serverIP = ("192.168.0.%d", boardID);
    receiver.startServer(serverIP, 6000);
}