#include "serverSide.h"
#include "EthernetInterface.h"
#include "LM75B.h"
#include "C12832.h"

Server::Server() {    
}

Server::~Server() {
    delete data;
    
}

void Server::startServer(const char ipServer, int portNumber) {
    //Making the Server
    printf("Server example\n\r");
    
    EthernetInterface eth;
    eth.set_network(&ipServer,"255.255.255.0","192.168.0.1");
    eth.connect();
    
    printf("The Server IP address is '%s'\n\r", eth.get_ip_address());
    
    TCPServer srv(&eth);  
    
    // Listening to the port that was given by user input
    srv.bind(portNumber);
    
    srv.listen();
    
    // While listening execute this code
    while(true){
        // Connecting the client to the server
        TCPSocket client;
        SocketAddress client_addr;
        char *buffer = "Hello TCP client!\r\n";
        
        srv.accept(&client, &client_addr);
        
        printf("Accepted %s:%d\n\r", client_addr.get_ip_address(), 
        client_addr.get_port());
                    
        client.send(buffer, 256);
        client.recv(data, sizeof data);
        readData();
        client.close();
        }
    
}

void Server::readData() {
        // Receiving the data we are measuring on the client board
        temp = float((data[0]<<8)|data[1]) / 256.0;
        pwm = data[2];
        senderID = data[3];
        printf("The temperature is: %f\r\n", temp);
        printf("The PWM value is: %d\r\n", pwm);
        printf("The ID from the sender is: %d\r\n", senderID);
        printToLCD();
    
}

void Server::printToLCD() {
        // Printing out the received data to our LCD screen from the Sever board
        C12832 lcd(D11, D13, D12, D7, D10);
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Temp = %.1f\n", temp);
        lcd.printf("PWM = %d\n", pwm);
        lcd.printf("ID Sender = %d\n", senderID);
        
}