#include "clientSide.h"
#include "mbed.h"
#include "EthernetInterface.h"
#include "LM75B.h"

Client::Client(){
    // Activating the sensors for transmitting data
    LM75B tsensor(D14,D15);
    AnalogIn pot (A0);
    temp = tsensor.read();
    getValues(temp, pot);

}

Client::~Client(){
    delete data;

}

void Client::startClient(const char ipClient, const char ipServer, int portNumber){
    //Making connection to the network
    printf("Client example\n\r");

    EthernetInterface eth;
    eth.set_network(&ipClient,"255.255.255.0","192.168.0.1");
    eth.connect();
    printf("The client IP address is '%s'\n\r", eth.get_ip_address());
    
    // Making a socket object so we can transmit data across the connection we made earlier
    TCPSocket socket;

    // Connecting the socket to the server ip and port
    socket.open(&eth);
    socket.connect(&ipServer, portNumber);

    char rbuffer[64];
    int rcount = socket.recv(rbuffer, sizeof rbuffer);
    printf("received: %d\r\n", rcount);
    printf(rbuffer);
    
    socket.send(data, 4);
    socket.close();

}

void Client::getValues(uint16_t temp, float pot){
    // Getting the data (Temperature, PWM value and Sender ID)s
    char upperbyte = (temp >> 8) & 0xFF;
    char lowerbyte = temp & 0xFF;

    // Creating the data string with the bytes we want to send
    data[0] = upperbyte;
    data[1] = lowerbyte;
    data[2] = (char)(pot*255);
    data[3] = (char)(34);

}