#include "mbed.h"
#include "ClockControl/ClockControl.h"
#include "CoreMark/core_portme.h"

int main() {
    while(1) {   
    

    printf("mbed Clock Control test\r\n");
    printf("(c) 2010 Michael Wei\r\n");
    
    unsigned short newM = 12;
    unsigned short newN = 1;
    
    printf("Value of M? (default = 12):\r\n");
    scanf("%d", &newM);
    
    printf("Value of N? (default = 1):\r\n");
    scanf("%d", &newN);
    
    setSystemFrequency(0x3, 0x1, newM, newN);
    
    Serial pc(USBTX, USBRX); // tx, rx
    
    //This code by Simon Ford: http://mbed.org/forum/mbed/topic/229/?page=1#comment-1225
    
    int Fin = 12000000; // 12MHz XTAL
    pc.printf("PLL Registers:\r\n");
    pc.printf(" - PLL0CFG = 0x%08X\r\n", LPC_SC->PLL0CFG);
    pc.printf(" - CLKCFG  = 0x%08X\r\n", LPC_SC->CCLKCFG);
    
    int M = (LPC_SC->PLL0CFG & 0xFFFF) + 1;
    int N = (LPC_SC->PLL0CFG >> 16) + 1;
    int CCLKDIV = LPC_SC->CCLKCFG + 1;

    pc.printf("Clock Variables:\r\n");
    pc.printf(" - Fin = %d\r\n", Fin);
    pc.printf(" - M   = %d\r\n", M);
    pc.printf(" - N   = %d\r\n", N);
    pc.printf(" - CCLKDIV = %d\r\n", CCLKDIV);

    int Fcco = (2 * M * 12000000) / N;
    int CCLK = Fcco / CCLKDIV;

    pc.printf("Clock Results:\r\n");    
    pc.printf(" - Fcco = %d\r\n", Fcco);
    
    printf(" - CCLK = %d\r\n", CCLK);
    
    printf("Run CoreMark? (Y/N)\n");
    char buf[8];
    scanf("%s", buf);
    if (buf[0] == 'y' || buf[0] == 'Y')
    {
        mainCoreMark();
    }
    
    wait(1);
    NVIC_SystemReset();
    }
}
