#include "mbed.h"
#include "Servo.h"
#include "PinNames.h"

#include    "F746_GUI.hpp"

Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut led(LED1);

Servo test_servo(D0);

int main()
{
    Label title(240, 2,
        "Servo - Tester. version: 0.1.0", Label::CENTER, Font16);
    Button buttonLed(10, 54, 50, 40, "Led");

    SeekBar barServo(20, 250, 200, 0, 100, 0, "0", "50", "100");
    NumericLabel<float> labelServo(130, 205, "%%%5.1f", barServo.GetValue());

    const int NUMBER_BUTTONS = 3;
    const string STR1[NUMBER_BUTTONS] = {
        "Left", "Center", "Right"};
    ButtonGroup bgroupPosition(160, 54, 66, 40,
        NUMBER_BUTTONS, STR1, 5, 5, 3, 1,
        Font12, LCD_COLOR_WHITE, 0xFF003538, 0xFFB70068);

    while(1) {
        float position;
        
        if (buttonLed.Touched()) {
            buttonLed.Draw();
            led = led.read() ^ 1;
            wait(0.5f);
        }
        if (barServo.Slide()) {
            labelServo.Draw("%%%5.1f", barServo.GetValue());
            position = barServo.GetValue() / 100;
            test_servo = position;
        }
        
        int num = 0;
        if (bgroupPosition.GetTouchedNumber(num)) {
            bgroupPosition.DrawAll();
            switch (num) {
                case 0:
                    position = 0.0f;
                    test_servo = position;
                    break;
                case 1:
                    position = 0.5f;
                    test_servo = position;
                    break;
                case 2:
                    position = 1.0f;
                    test_servo = position;
                    break;
            }
            barServo.SetValue(position*100);
            barServo.Redraw();
            labelServo.Draw("%%%5.1f", barServo.GetValue());
            wait(0.5f);
        }

        wait(0.02f);
    }
}
