#include "mbed.h"
#include "C12832.h"
#include "XBee.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

InterruptIn down(p12);
InterruptIn left(p13);
InterruptIn up(p15);
InterruptIn right(p16);

Serial xbee(p9,p10);

C12832 lcd(p5, p7, p6, p8, p11);    //Used for the LCD

char ID=0b00000010; //ID hardcoden
char Des=0b00000001;
char Item,Status,Checksum;

int i;

bool sending=1;

char control[6];
int teller;

Timer t;
//methode om te verzenden
void send(){
    xbee.putc(0x7E);    //beginflag
    xbee.putc(ID);  //waarvan wordt er verzonden
    xbee.putc(Des);     //naar waar wordt er verzonden
    xbee.putc(Item);    //over welke knop gaat het
    xbee.putc(Status);  //wat is de nieuwe status van de knop
    xbee.putc(Checksum);//controle van het bericht
    xbee.putc(0x7E);    //eindflag
}
//methode als de joystick omhoog komt
 void CalChecksumup(){
    Status=0b00000000; //status op "omhoog zetten"
    myled1=1;
    lcd.cls();
    lcd.locate(0,3);
    if(up.read()&&!left.read()&&!right.read()){ //als de joystick enkel omhoog staat 
        lcd.printf("up");                       
        Item=0b00000000;                        //item wordt joystick 0°
    }
    if(up.read()&&right.read()){                //als de joystick enkel rechtsomhoog staat 
        lcd.printf("upright");
        Item=0b00000001;                        //item wordt joystick 45°
    }
    if(right.read()&&!up.read()&&!down.read()){ //als de joystick rechts staat 
        lcd.printf("right");
        Item=0b00000010;                        //item wordt joystick 90°
    }
    if(down.read()&&right.read()){              //als de joystick rechtsomlaag staat
        lcd.printf("downright");
        Item=0b00000011;                        //item wordt joystick 135°
    }
    if(down.read()&&!left.read()&&!right.read()){//als de joystick omlaag staat
        lcd.printf("down");
        Item=0b00000100;                        //item wordt joystick 180°
    }
    if(down.read()&&left.read()){               //als joystick linkomlaag staat
        lcd.printf("downleft");
        Item=0b00000101;                        //item wordt joystick 225°
    }
    if(left.read()&&!up.read()&&!down.read()){  //als joystick link staat
        lcd.printf("left");
        Item=0b00000110;                        //item wordt joystick 270°
    }
    if(up.read()&&left.read()){                 //als joystick linksomhoog staat
        lcd.printf("upleft");
        Item=0b00000111;                        //item wordt joystick 315°
    }
    Checksum=(ID+Des+Item+Status)%255;      //de checksum wordt berekend
    sending=0;                                  //sending wordt op nul gezet zodat de xbee kan lezen
    send();                                     //de methode send wordt aangeroepen
    t.start();                                  //een timer wordt gestart
}
//methode als de joystick terug losgelaten worden
 void CalChecksumdown(){
    Status=0b00000001;          //status wordt op omlaag gezet
    myled1=0;
    lcd.cls();
    lcd.locate(0,3);
    if(Item==0b00000000){       //als de joystick omhoog stond wordt deze als omlaag verzonden
        lcd.printf("back");
        Item=0b00000000;
    }
    if(Item==0b00000001){       //als de joystick rechtsomhoog stond wordt deze als omlaag verzonden
        lcd.printf("back");
        Item=0b00000001;
        if(up.read()){          //als de joystick naar omhoog verplaatst wordt, wordt de status overschreven naar hoog en de item naar 0°
            Item=0b00000000;
            Status=0b00000000;
        }
        if(right.read()){       //als de joystick naar rechts verplaatst wordt, wordt de status overschreven naar hoog en de item naar 90°
            Item=0b00000010;
            Status=0b00000000;
        }
    }
    if(Item==0b00000010){       //als de joystick naar rechts stond wordt deze als omlaag verzonden
        lcd.printf("back");
        Item=0b00000010;
    }
    if(Item==0b00000011){       //als de joystick naar rechtsonder stond wordt dezel als omlaag verzonden
        lcd.printf("back");
        Item=0b00000011;
        if(right.read()){       //als de joystick naar rechts verplaatst wordt, wordt de status overschreven naar hoog en de item naar 90°
            Item=0b00000010;
            Status=0b00000000;
        }
        if(down.read()){        //als de joystick naar onder verplaatst wordt, wordt de status overschreven naar hoog en de item naar 180°
            Item=0b00000100;
            Status=0b00000000;
        }
    }
    if(Item==0b00000100){       //als de joystick naar onder stond wordt deze als omlaag verzonden
        lcd.printf("back");
        Item=0b00000100;
    }
    if(Item==0b00000101){       //als de joystick naar linksonder stond wordt deze als omlaag verzonden
        lcd.printf("back");
        Item=0b00000101;
        if(down.read()){        //als de joystick naar onder verplaatst wordt, wordt de status overschreven naar hoog en de item naar 180°
            Item=0b00000100;
            Status=0b00000000;
        }
        if(left.read()){        //als de joystick naar links verplaatst wordt, wordt de status overschreven naar hoog en de item naar 270°
            Item=0b00000110;
            Status=0b00000000;
        }
    }
    if(Item==0b00000110){       //als de joystick naar links stond wordt deze als omlaag verzonden
        lcd.printf("back");
        Item=0b00000110;
    }
    if(Item==0b00000111){       //als de joystick naar linksboven stond wordt deze als omlaag verzonden
        lcd.printf("back");
        Item=0b00000111;
        if(left.read()){        //als de joystick naar links verplaatst wordt, wordt de status overschreven naar hoog en de item naar 270°
            Item=0b00000110;
            Status=0b00000000;
        }
        if(up.read()){          //als de joystick naar boven verplaatst wordt, wordt de status overschreven naar hoog en de item naar 0°
            Item=0b00000000;
            Status=0b00000000;
        }
    }
    Checksum=(ID+Des+Item+Status)%255;// de checksum wordt berekend
    sending=0;                            //sending wordt op 0 gezet zodat de xbee kan ontvangne
    send();                               //de send methode wordt aangeroepen
    t.start();                            //de timer wordt gestart
}

int main() {
    xbee.baud(57600);//initatilatien van de xbee
    while(1) {
        if(sending){//als sendeing =1 is kan er verzonden worden
            //als de joystick omhoog of terug bewogen word zal de functie up of down aangeroepen worden
            up.rise(&CalChecksumup);
            up.fall(&CalChecksumdown);
            down.rise(&CalChecksumup);
            down.fall(&CalChecksumdown);
            left.rise(&CalChecksumup);
            left.fall(&CalChecksumdown);
            right.rise(&CalChecksumup);
            right.fall(&CalChecksumdown);
        }
        if(!sending){                       //als sending =0 is kan de xbee de ack of nack lezen
            if(xbee.readable()) {           //Checks if the data is readable
                xbee.gets(control,6);       //de xbee leest de ontvangen frame in de array in
                if(control[2]==ID){         //als de boodschap voor deze module bedoelt is
                    if(control[1]==Des){    //als de afzender correct is
                        if(control[0]==0x7D){        //als de beginflag ontvangen is wordt er gekeken of de eindflag juist ontvangen is
                            if(control[5]==0x7D){    //als de eindflag juist ontvangne is wordt de checksum gecontroleerd
                                Checksum=(control[1]+control[2]+control[3])%255;
                                if(Checksum==control[4]){   //als de checksum correct is wordt er bekeken of het ACK of NACK signaal ontvan is 
                                    if(control[3]==0b00001111){ //als het ACK ontvangen is
                                        sending=1;                  //sending wordt terug op 1 gezet waardoor er terug een knop verzonden kan worden
                                        lcd.cls();
                                        lcd.locate(0,3);
                                        lcd.printf("ACK");
                                        t.stop();                   //de timer wordt gestopt en gereset
                                        t.reset();
                                        teller=0;                   //de teller wordt op nul gezet
                                        while(i<7){                 //de controle array wordt gewist
                                            control[i]=0;
                                            i++;
                                        }
                                        i=0;
                                    }
                                    if(control[3]==0b11110000){     //als de checksum niet correct is
                                        lcd.cls();
                                        lcd.locate(0,3);
                                        lcd.printf("NACK");
                                        if(teller<10){              //wordt er max 10 maal de frames herzonden
                                            send();
                                            teller++;
                                        }
                                        if(teller==10){             //als het signaal na 10 maal niet correct wordt doorgestuurd wordt het ge negeert
                                            sending=1;
                                            teller=0;
                                        }   
                                        lcd.cls();
                                        lcd.locate(0,3);
                                        lcd.printf("NO REACTION");
                                    }
                                }   
                            }
                            if(t>=1){   //als er na 1 seconden geen signaal aankomt wordt deze herzonden
                                t.stop();
                                t.reset();
                                send();
                                t.start();
                            }
                        }
                    }
                }   
            }
        }
    }
}