#include "mbed.h"
#include "C12832.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

Serial xbee(p9,p10);
//DigitalOut nReset(p30);             //reset pin of the xbee

C12832 lcd(p5, p7, p6, p8, p11);    //Used for the LCD

char a;
int ID=0b00000001;
int ACK;
int teller;
char received[7];
int check;
int i;
int Checksum;
// methode zenden
void send(){
    xbee.putc(0x7E);
    xbee.putc(ID);
    xbee.putc(received[1]);
    xbee.putc(ACK);
    xbee.putc(Checksum);
    xbee.putc(0x7E);
}

int main(){
    xbee.baud(57600); //xbee klaarzetten
    while(1){
        if(xbee.readable()) {       //Checks if the data is readable
            xbee.gets(received,8);  //laad het frame in de array in
            check=(received[1]+received[2]+received[3]+received[4])%255; //checksum berekeken
            if(received[2]==ID){ //als de boodschap voor deze module bedoeld is
                if(received[0]==0x7E){  //als de startflag ontvangen is
                    myled1=!myled1;
                    if(received[6]==0x7E){  //als de eindflag ontvangen is
                        myled2=!myled2;
                        if(check==received[5]) {//als de checksum klopt
                            myled3=!myled3;
                            teller++;
                            lcd.cls();
                            lcd.printf("%d",teller);
                            ACK=0b00001111; //ack als ack instellen
                            Checksum=(ID+received[1]+ACK)%255; //nieuwe checksum berekenen
                            send();                            //verzenden
                            while(i<5){                        //array leegmaken
                                received[i]=0;
                                i++;
                            }
                            i=0;
                        }
                        if(received[5]!=check){                //als de checksum niet klopt
                            myled4=!myled4;
                            ACK=0b11110000;                    //ack als NACK instellen
                            Checksum=(ID+received[1]+ACK)%255; //nieuwe checksum berekenen
                            send();                            //verzenden
                            while(i<5){                        //array leegmaken
                                received[i]=0;
                                i++;
                            }
                            i=0;
                        }
                    }
                }
            }
        }
    }
}