/* Program for using Ultrasonic Sensor - Modified by Moorthy Muthukrishnan.
    April 2015.  */
/* Trigger is supplied through Port E, Pin 5 for sending the pulse
   Uses interrupt in Port A, pin 16  to determine the pulse width  */

#include "mbed.h"
#include "TextLCD.h"

 Serial pc(USBTX,USBRX);  //Serial port to communicate with the PC
 TextLCD lcd(PTA13, PTD5, PTD0, PTD1, PTD2, PTD3, TextLCD::LCD16x2); // RS, E, D4-D7
 DigitalOut trig(PTE5,0);  //Configuring the pin for Trigger
 InterruptIn echo(PTA16);   //Configuring the pin for Echo 
 Timer temp;
 float tdist=0, distcm=0, distin=0, dist0=0;
    
// Function for starting the timer to mark the first edge of echo
void iniP()
{            
    temp.start();      
    return;
}

//Function for stopping the timer to mark the end of echo pulse      
void finP()
{ 
    
    tdist = temp.read_us();  //Read the timer in Microseconds
    distcm = tdist/58;       //Calculate the distance in "cm"
    distin = tdist/148;      //Calculate the distance in "inch"
        
    temp.stop();           //Stop the timer
    temp.reset();          //Reset the timer
    return;
}
             
int main()
{
    pc.printf("Starting the Distance sensor\n"); 
    lcd.locate(0, 0);
    lcd.printf("Distance sensor\n");
        
    while(1)
    {  
        trig=1;             //make the trigger = 1
        wait_us(10);        // 10us pulse
        trig=0;             //Make trigger = 0
            
        echo.rise(&iniP);   //Rising edte of the pulse
        echo.fall(&finP);   //Falling edge of the pulse
            
        // display the distance in cm
        if(distcm != dist0)
        { 
            dist0 = distcm;
            if (distcm < 3000.0)
            {
                pc.printf("Distance detected by the sensor %.2f cm \n\n",distcm);
                lcd.locate(0,1);
                lcd.printf("Distance=%.2fcm\n", distcm);
            }
            else 
            {
                 pc.printf("Error in distance measurement \n\n");
                 lcd.locate(0,1);
                 lcd.printf("Error\n");
            }   
        }
           wait_ms(3000);     //Wait before sending the next pulse           
    }
             
}

// End of main 