#include "mbed.h"
#include "MMA8451Q.h"
#include <cstdlib>
#include <iostream>

Serial HC06(PTC4,PTC3);
AnalogIn analog_value(A0);
DigitalOut buz(PTD7);

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
PinName const SDA = PTE25;
PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
PinName const SDA = PTB4;
PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
PinName const SDA = PTB1;
PinName const SCL = PTB0;

#else

#error TARGET NOT DEFINED
#endif
#define MMA8451_I2C_ADDRESS (0x1d<<1)

int main(void)
{
    HC06.baud(9600);

    float meas;
    printf("\nAnalogIn example\n");
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);

    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);

    printf("MMA8451 ID: %d\n", acc.getWhoAmI());
    using namespace std;

    while(1)
    {
        printf("\nAnalogIn example\n");
        while (true)
        {
            float x, y, z;
            x = abs(acc.getAccX());
            y = abs(acc.getAccY());
            z = abs(acc.getAccZ());
            rled = 1.0f - x;
            gled = 1.0f - y;
            bled = 1.0f - z;
            wait(0.1f);
            printf("X: %1.2f, Y: %1.2f, Z: %1.2f\r\n", x, y, z);
            HC06.printf("\nX: %1.2f, Y: %1.2f, Z: %1.2f\n", x, y, z);

            meas = analog_value.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
            meas = meas * 3300; // Change the value to be in the 0 to 3300 range
            printf("measure = %1.0f mV\r\n\n\n", meas);
            HC06.printf("measure = %1.0f mV\n", meas);
            if(x > 0.8){buz = 1; goto ex;}else {buz = 0;}
            if(y > 0.8){buz = 1; goto ex;}else {buz = 0;}
            if(z < 0.5){buz = 1; goto ex;}else {buz = 0;}
            
            if (meas < 1850)// If the value is greater than 2V then switch the LED on
                buz = 1;
            else
            buz = 0;
        ex: wait(0.2); // 200 ms

        }

    }

}
