#include "mbed.h"
#include "TSISensor.h"
#include "MMA8451Q.h"
#include <cstdlib>
#include <iostream>

TSISensor tsi;
MMA8451Q acc(PTE25, PTE24, 0x1D<<1);
PwmOut rled(LED_RED);
PwmOut gled(LED_GREEN);
PwmOut bled(LED_BLUE);
DigitalOut testPin(PTC7);

Serial bt(PTC4, PTC3);

int main() {
    using namespace std;
    
    float onTime = 1.0;
//    float offTime = 0.0;
    float holdTime = 1.0;
//    bool on = true;
    bool off = false;
    char bt_msg[100] = "";
    
    
    while(true) {
        
        rled = onTime - abs(acc.getAccX());
        gled = onTime - abs(acc.getAccY());
        bled = onTime - abs(acc.getAccZ());
        testPin = rand() % 2;
        cout << "MMA8451Q: " << acc.getAccX() << "\t" << acc.getAccY() << "\t" << acc.getAccZ() << "\n\r" << flush << endl; 
//        bt.printf("this is a bluetooth test\n");
        wait(holdTime);
        
//        if(bt.readable()){
//            bt.putc(bt.getc());
//        }
        if(bt.readable()){
            bt.scanf("%s", bt_msg, sizeof(bt_msg));
        }
        
        rled = onTime - tsi.readPercentage();
        gled = onTime - tsi.readPercentage();
        bled = onTime - tsi.readPercentage();
        testPin = off;
        cout << "Touch Sensor: " << tsi.readPercentage() << "\n\r" << flush << endl;
//        bt.printf("this is also a bluetooth test\n");
        bt.printf("%s\n", bt_msg);
        wait(holdTime);
    }
}
