
/* 
    Stepper Motor Driver Program version 2
    
    Written By N. Moorthy Muthukrishnan, Hyderabad, India  Date : 27 July 2016
 
    This program is written for FRDM KL25Z for driving unipolar stepper motor  with four coils and common terminal
    Stepper Motor Model RoHS 28BYJ-48 12 VDC, use only 5 VDC power supply for driver board. 
    
    Four wires from the stepper motor are of colors blue, pink, yellow, and orange.
    Connected to PTB8, PTB9, PTB10, and PTB11, respectively.
    
    Red wire is common.
   
    Blue  = coil 1      Pink  = coil 2
    Yellow = coil 3     Orange = coil 4
    Red = common
    
    A ULN2003 driver board is used to drive the stepper motor. 
    A Variable named mode is used to select the mode of operation of the stepper motor. 
    wave drive   mode = 0
    full step    mode = 1
    half step    mode = 2
    
    A variable dir is used to define the direction of rotation
    direction    dir = 0  anticlockwise
    direction    dir = 1  clockwise
*/

#include "mbed.h"

#define DLY 0.1  // delay in seconds

DigitalOut blue(PTB8);
DigitalOut pink(PTB9);
DigitalOut yellow(PTB10);
DigitalOut orange(PTB11);
Serial pc(USBTX,USBRX);

//variable
static int mode = 0;
static int dir = 0;

void wave_anticlockwise(void);
void fullstep_anticlockwise(void);
void halfstep_anticlockwise(void);

void wave_clockwise(void);
void fullstep_clockwise(void);
void halfstep_clockwise(void);

void motor_idle(void);

int main() 
{
    
    // enter mode in the following line
    // 0 for wave drive, 1 for full step, 2 for half step
    
    mode = 0;
    
    //enter dir = 0 for anticlockwise rotation, dir = 1 for clockwise rotation
    dir = 0;
    
    pc.printf("\n\r");
    pc.printf("****** Stepper Motor starting ******* \n\r");
    pc.printf("Mode = %d  Direction = %d  \n\r", mode, dir);
    
    while (true) 
    {
        if (dir == 0)
        {
            pc.printf("Motor in anticlockwise rotation\n\r");
            // wave drive
            if (mode == 0)  
            {
                wave_anticlockwise();
            }
        
            // full step
            else if (mode == 1)
            {
                fullstep_anticlockwise();
            }
        
            // half step
            else if (mode == 2)
            {
                halfstep_anticlockwise();
            }
            else 
            {
                pc.printf("Invalid mode, Motor idle \n\r");
                motor_idle();
            }
        }
        
        else if (dir == 1)
        {
            pc.printf("Motor in clockwise rotation \n\r");
            // wave drive
            if (mode == 0)  
            {
                wave_clockwise();
            }
        
            // full step
            else if (mode == 1)
            {
                fullstep_clockwise();
            }
        
            // half step
            else if (mode == 2)
            {
                halfstep_clockwise();
            }
            
            else 
            {
                pc.printf("Invalid mode, Motor idle \n\r");
                motor_idle(); 
            }
            
        }
        
        else
        {
            pc.printf("Invalid direction, Motor idle \n\r");
            motor_idle();
        }
        
    }
}

// function for wave drive in anticlockwise direction
void wave_anticlockwise()
{
    pc.printf("Motor in wave drive \n\r");
    blue = 0;
    pink = 0;
    yellow = 0;
    orange = 1;
    wait(DLY);
        
    blue = 0;
    pink = 0;
    yellow = 1;
    orange = 0;
    wait(DLY);
        
    blue = 0;
    pink = 1;
    yellow = 0;
    orange = 0;
    wait(DLY);
        
    blue = 1;
    pink = 0;
    yellow = 0;
    orange = 0;
    wait(DLY);
}

// function for full step in anticlockwise direction
void fullstep_anticlockwise()
{
    pc.printf("Motor in full step \n\r");
    blue = 0;
    pink = 0;
    yellow = 1;
    orange = 1;
    wait(DLY);
        
    blue = 0;
    pink = 1;
    yellow = 1;
    orange = 0;
    wait(DLY);
        
    blue = 1;
    pink = 1;
    yellow = 0;
    orange = 0;
    wait(DLY);
        
    blue = 1;
    pink = 0;
    yellow = 0;
    orange = 1;
    wait(DLY);  
}

// function for half step in anticlockwise direction
void halfstep_anticlockwise()
{
    pc.printf("Motor in half step \n\r");
    blue = 0;
    pink = 0;
    yellow = 0;
    orange = 1;
    wait(DLY);
        
    blue = 0;
    pink = 0;
    yellow = 1;
    orange = 1;
    wait(DLY);
        
    blue = 0;
    pink = 0;
    yellow = 1;
    orange = 0;
    wait(DLY);
        
    blue = 0;
    pink = 1;
    yellow = 1;
    orange = 0;
    wait(DLY);
        
    blue = 0;
    pink = 1;
    yellow = 0;
    orange = 0;
    wait(DLY);
        
    blue = 1;
    pink = 1;
    yellow = 0;
    orange = 0;
    wait(DLY);
        
    blue = 1;
    pink = 0;
    yellow = 0;
    orange = 0;
    wait(DLY);
        
    blue = 1;
    pink = 0;
    yellow = 0;
    orange = 1;
    wait(DLY);
    
}

// function for wave drive in clockwise direction
void wave_clockwise()
{
    pc.printf("Motor in wave drive \n\r");
    blue = 1;
    pink = 0;
    yellow = 0;
    orange = 0;
    wait(DLY);
        
    blue = 0;
    pink = 1;
    yellow = 0;
    orange = 0;
    wait(DLY);
        
    blue = 0;
    pink = 0;
    yellow = 1;
    orange = 0;
    wait(DLY);
        
    blue = 0;
    pink = 0;
    yellow = 0;
    orange = 1;
    wait(DLY);
}

// function for full step in clockwise direction
void fullstep_clockwise()
{
    pc.printf("Motor in full step \n\r");
                
    blue = 1;
    pink = 0;
    yellow = 0;
    orange = 1;
    wait(DLY);
        
    blue = 1;
    pink = 1;
    yellow = 0;
    orange = 0;
    wait(DLY);
        
    blue = 0;
    pink = 1;
    yellow = 1;
    orange = 0;
    wait(DLY);
        
    blue = 0;
    pink = 0;
    yellow = 1;
    orange = 1;
    wait(DLY);  
}

void halfstep_clockwise()
{
    halfstep_clockwise();
    pc.printf("Motor in half step \n\r");
    blue = 0;
    pink = 0;
    yellow = 0;
    orange = 1;
    wait(DLY);
        
    blue = 1;
    pink = 0;
    yellow = 0;
    orange = 1;
    wait(DLY);
        
    blue = 0;
    pink = 0;
    yellow = 1;
    orange = 0;
    wait(DLY);
        
    blue = 1;
    pink = 1;
    yellow = 0;
    orange = 0;
    wait(DLY);
        
    blue = 0;
    pink = 1;
    yellow = 0;
    orange = 0;
    wait(DLY);
        
    blue = 0;
    pink = 1;
    yellow = 1;
    orange = 0;
    wait(DLY);
        
    blue = 1;
    pink = 0;
    yellow = 0;
    orange = 0;
    wait(DLY);
        
    blue = 0;
    pink = 0;
    yellow = 1;
    orange = 1;
    wait(DLY);
}

void motor_idle()
{
    blue = 0;
    pink = 0;
    yellow = 0;
    orange = 0;
    wait(DLY); 
    
}