/* 
    Written by Moorthy Muthukrishnan 
    KL25Z program for driving bipolar stepper motor 
    Stepper motor model 17HA0403-32N
    Driver board using L293D H-bridge driver IC
    Note:
    ULN2003-based drivers work well for unipolar stepper motors
      but did not work with the bipoar stepper motors. 
      
    IN1A  = Coil A+      IN1B  = Coil B+
    Y = coil 3     Orange = coil 4
    Red = common
    
    A Variable named mode is used to select the mode of operation of the stepper motor. 
    wave drive   mode = 0
    full step    mode = 1
    half step    mode = 2
    
    A variable named dir is used to define the direction of rotation
    direction    dir = 0  anticlockwise
    direction    dir = 1  clockwise
*/

//Libraries needed 
#include "mbed.h"

#define DLY 0.1 // DLY 1s

//Input pins on Eval Board
DigitalOut IN1A(PTB8);         // Pin IN1A input to EVAL board (FRDM PIN Name)
DigitalOut IN1B(PTB9);         // Pin IN1B input to EVAL board (FRDM PIN Name)
DigitalOut IN2A(PTB10);        // Pin IN2A input to EVAL board (FRDM PIN Name)
DigitalOut IN2B(PTB11);        // Pin IN2B input to EVAL board (FRDM PIN Name)
Serial pc(USBTX,USBRX);

//variable
static int mode = 0;
static int dir = 0;

void wave_anticlockwise(void);
void fullstep_anticlockwise(void);
void halfstep_anticlockwise(void);

void wave_clockwise(void);
void fullstep_clockwise(void);
void halfstep_clockwise(void);

void motor_idle(void);

int main() 
{
    
    // enter mode in the following line
    // 0 for wave drive, 1 for full step, 2 for half step
    
    mode = 0;
    
    //enter dir = 0 for anticlockwise rotation, dir = 1 for clockwise rotation
    dir = 1;
    
    pc.printf("\n\r");
    pc.printf("****** Stepper Motor starting ******* \n\r");
    pc.printf("Mode = %d  Direction = %d  \n\r", mode, dir);
    
    while (true) 
    {
        if (dir == 0)
        {
            pc.printf("Motor in anticlockwise rotation\n\r");
            // wave drive
            if (mode == 0)  
            {
                wave_anticlockwise();
            }
        
            // full step
            else if (mode == 1)
            {
                fullstep_anticlockwise();
            }
        
            // half step
            else if (mode == 2)
            {
                halfstep_anticlockwise();
            }
            else 
            {
                pc.printf("Invalid mode, Motor idle \n\r");
                motor_idle();
            }
        }
        
        else if (dir == 1)
        {
            pc.printf("Motor in clockwise rotation \n\r");
            // wave drive
            if (mode == 0)  
            {
                wave_clockwise();
            }
        
            // full step
            else if (mode == 1)
            {
                fullstep_clockwise();
            }
        
            // half step
            else if (mode == 2)
            {
                halfstep_clockwise();
            }
            
            else 
            {
                pc.printf("Invalid mode, Motor idle \n\r");
                motor_idle(); 
            }
            
        }
        
        else
        {
            pc.printf("Invalid direction, Motor idle \n\r");
            motor_idle();
        }
        
    }
}

// function for wave drive in anticlockwise direction
void wave_anticlockwise()
{
    pc.printf("Motor in wave drive \n\r");
    
    //State8        
    IN1A = 1;       //coil A +, coil B 0
    IN1B = 0;
    IN2A = 0;
    IN2B = 0;
    wait(DLY);
    
    //State6   
    IN1A = 0;       //coil A 0, coil B -
    IN1B = 0;
    IN2A = 0;
    IN2B = 1;
    wait(DLY);
    
    //State4       
    IN1A = 0;       //coil A -, coil B 0
    IN1B = 1;
    IN2A = 0;
    IN2B = 0;
    wait(DLY);
    
    //State2
    IN1A = 0;       //coil A 0, coil B +
    IN1B = 0;
    IN2A = 1;
    IN2B = 0;
    wait(DLY);
}

// function for full step in anticlockwise direction
void fullstep_anticlockwise()
{
    pc.printf("Motor in full step \n\r");
    
    //State7
    IN1A = 1;       //coil A +, coil B -
    IN1B = 0;
    IN2A = 0;
    IN2B = 1;
    wait(DLY);
    
    //State5       
    IN1A = 0;       //coil A -, coil B -
    IN1B = 1;
    IN2A = 0;
    IN2B = 1;
    wait(DLY);   
    
    //State3
    IN1A = 0;       //coil A -, coil B +
    IN1B = 1;
    IN2A = 1;
    IN2B = 0;
    wait(DLY);
    
    //State1            
    IN1A = 1;       //coil A +, coil B +
    IN1B = 0;
    IN2A = 1;
    IN2B = 0;
    wait(DLY);
         
}

// function for half step in anticlockwise direction
void halfstep_anticlockwise()
{
    pc.printf("Motor in half step \n\r");

    //State8
    IN1A = 1;       //coil A +, coil B 0
    IN1B = 0;
    IN2A = 0;
    IN2B = 0;
    wait(DLY);
    
    //State7
    IN1A = 1;       //coil A +, coil B -
    IN1B = 0;
    IN2A = 0;
    IN2B = 1;
    wait(DLY);
    
    //State6
    IN1A = 0;       //coil A 0, coil B -
    IN1B = 0;
    IN2A = 0;
    IN2B = 1;
    wait(DLY);
    
    //State5
    IN1A = 0;       //coil A -, coil B -
    IN1B = 1;
    IN2A = 0;
    IN2B = 1;
    wait(DLY);  
    
    //State4
    IN1A = 0;       //coil A -, coil B 0
    IN1B = 1;
    IN2A = 0;
    IN2B = 0;
    wait(DLY);   
    
    //State3
    IN1A = 0;       //coil A -, coil B +
    IN1B = 1;
    IN2A = 1;
    IN2B = 0;
    wait(DLY);
    
    //State2
    IN1A = 0;       //coil A 0, coil B +
    IN1B = 0;
    IN2A = 1;
    IN2B = 0;
    wait(DLY);
    
    //State1
    IN1A = 1;       //coil A +, coil B +
    IN1B = 0;
    IN2A = 1;
    IN2B = 0;
    wait(DLY);   
}

// function for wave drive in clockwise direction
void wave_clockwise()
{
    pc.printf("Motor in wave drive \n\r");
    
    //State2
    IN1A = 0;       //coil A 0, coil B +
    IN1B = 0;
    IN2A = 1;
    IN2B = 0;
    wait(DLY);
    
    //State4       
    IN1A = 0;       //coil A -, coil B 0
    IN1B = 1;
    IN2A = 0;
    IN2B = 0;
    wait(DLY);
    
    //State6   
    IN1A = 0;       //coil A 0, coil B -
    IN1B = 0;
    IN2A = 0;
    IN2B = 1;
    wait(DLY);
    
    //State8        
    IN1A = 1;       //coil A +, coil B 0
    IN1B = 0;
    IN2A = 0;
    IN2B = 0;
    wait(DLY);
}

// function for full step in clockwise direction
void fullstep_clockwise()
{
    pc.printf("Motor in full step \n\r");
    
    //State1            
    IN1A = 1;       //coil A +, coil B +
    IN1B = 0;
    IN2A = 1;
    IN2B = 0;
    wait(DLY);
        
    //State3
    IN1A = 0;       //coil A -, coil B +
    IN1B = 1;
    IN2A = 1;
    IN2B = 0;
    wait(DLY);
    
    //State5       
    IN1A = 0;       //coil A -, coil B -
    IN1B = 1;
    IN2A = 0;
    IN2B = 1;
    wait(DLY);       
    
    //State7
    IN1A = 1;       //coil A +, coil B -
    IN1B = 0;
    IN2A = 0;
    IN2B = 1;
    wait(DLY);
}

void halfstep_clockwise()
{
    pc.printf("Motor in half step \n\r");

    //State1
    IN1A = 1;       //coil A +, coil B +
    IN1B = 0;
    IN2A = 1;
    IN2B = 0;
    wait(DLY);
        
    //State2
    IN1A = 0;       //coil A 0, coil B +
    IN1B = 0;
    IN2A = 1;
    IN2B = 0;
    wait(DLY);
    
    //State3
    IN1A = 0;       //coil A -, coil B +
    IN1B = 1;
    IN2A = 1;
    IN2B = 0;
    wait(DLY);
            
    //State4
    IN1A = 0;       //coil A -, coil B 0
    IN1B = 1;
    IN2A = 0;
    IN2B = 0;
    wait(DLY);
        
    //State5
    IN1A = 0;       //coil A -, coil B -
    IN1B = 1;
    IN2A = 0;
    IN2B = 1;
    wait(DLY);       
    
    //State6
    IN1A = 0;       //coil A 0, coil B -
    IN1B = 0;
    IN2A = 0;
    IN2B = 1;
    wait(DLY);
            
    //State7
    IN1A = 1;       //coil A +, coil B -
    IN1B = 0;
    IN2A = 0;
    IN2B = 1;
    wait(DLY);
            
    //State8
    IN1A = 1;       //coil A +, coil B 0
    IN1B = 0;
    IN2A = 0;
    IN2B = 0;
    wait(DLY);
}

void motor_idle()
{
    //State0
    IN1A = 0;       //coil A 0, coil B 0
    IN1B = 0;
    IN2A = 0;
    IN2B = 0;
    wait(DLY);   
}

 
