/**----------------------------------------------------------------------------
 *
 *            \file frequency_detector.cpp
--                                                                           --
--              ECEN 5803 Mastering Embedded System Architecture             --
--                  Project 1 Module 4                                       --
--                Microcontroller Firmware                                   --
--                      frequency_detector.cpp                                           --
--                                                                           --
-------------------------------------------------------------------------------
--
--  Designed for:  University of Colorado at Boulder
--                
--                
--  Designed by:  Tim Scherr
--  Revised by:  Naved Maududi and Bryan Cisneros 
-- 
-- Version: 2.1
-- Date of current revision:  2017-09-25   
-- Target Microcontroller: Freescale MKL25ZVMT4 
-- Tools used:  ARM mbed compiler
--              ARM mbed SDK
--              Freescale FRDM-KL25Z Freedom Board
--               
--               
   Functional Description:  
   This file contains code that takes in quasi-sine wave ADC inputs from the flow meter
     From the ADC inputs, it calculates the frequency of that sine wave. The frequency is 
     important in determining the flow rate and velocity for the flowmeter that are outputed
     to the display. 
-- 
--      Copyright (c) 2015 Tim Scherr  All rights reserved.
*/


#include "shared.h" 

#ifdef __cplusplus 
extern "C" {
#endif
/**********************/   
/*   Definitions     */
/**********************/

extern uint16_t zero_detect_counter = 0; // initialize the value to zero
extern UCHAR sample_count =0; // intialize sample count to zero
extern uint32_t frequency_buffer[10] = {0,0,0,0,0,0,0,0,0,0};
extern UCHAR frequency_buffer_count = 0;
extern UCHAR reset_counter_flag = 0;
extern UCHAR current_bool_value =1; // trigger for zero detection within the code
extern UCHAR last_bool_value = 1; // trigger for zero detection within the code

    
#ifdef __cplusplus
}
#endif

// read in ADC from the professor and store it within this function (ADC() will store a value within 
//will write code to keep going through this buffer, need to be able to store value to this function fast enough
//uint16_t ADC_buffer;
//UCHAR size_ADC_array = 10;
void frequency_detect(void)
{  int32_t i;
    
   if(reset_counter_flag==1)
         {
       zero_detect_counter = 0; // reset the value of counter each 800us has passed, want to attain the moving average(fed from timer0.cpp)
         reset_counter_flag=0; // set reset flag back to 0
    }

      if(ADC_vortex_frequency_input<=0) 
          {
             current_bool_value =0; // negative values set to 0
          }
             else
             {
             current_bool_value =1; // positive value set to 1
       }
             
        if((current_bool_value != last_bool_value))
        {
   last_bool_value = current_bool_value;
   zero_detect_counter = zero_detect_counter+1;
            
     if ((frequency_buffer_count<10) && (zero_detect_counter>=2))
     {
         frequency_buffer[frequency_buffer_count]  = ((zero_detect_counter-1)/((sample_count)*(SAMPLES_SECOND)))/2;
             frequency_buffer_count = frequency_buffer_count+1;
     }
    else 
        {
            frequency_buffer_count = 1;
    }
   
    }
    
  if((zero_detect_counter == 0) & (reset_counter_flag == 0))
    {
      sample_count = 1;
  }
    else if(zero_detect_counter>0)
    {
    sample_count++; // only evaluated at the beginning of code during resets
  }
    else {
        sample_count = 1; // needed to not divide by zero
    }

        uint16_t sum_frequency_buffer= 0;

        for(i = 1; i < 10; ++i)
    {
        sum_frequency_buffer += frequency_buffer[i];
    }
        
        if ((sum_frequency_buffer/9)>3000)
        {
            freq_value = 0;
        }
    else
        {
           freq_value = sum_frequency_buffer/9;
        }

}


    
