#include "mbed.h"
#include "rtos.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "uLCD_4DGL.h"

BusOut myled(LED1,LED2,LED3,LED4);
Serial  pc(USBTX, USBRX);
Serial  dev(p28,p27);
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;
AnalogOut DACout(p18);
PwmOut red(p21);
PwmOut green(p22);
PwmOut blue(p23);
wave_player waver(&DACout);
DigitalOut led1(LED1);
DigitalOut led4(LED4);

Mutex mutex;

inline float random_number()
{
    return (rand()/(float(RAND_MAX)));
}

void rgb(void const *args) {
    while(1) {
        for (int i = 0; i < 10; i++) {
            red = i / 10.0;
            green = ((i + 3) % 10) / 10.0;
            blue = ((i + 6) % 10) / 10.0;
            Thread::wait(100);  
            
        }

        for (int i = 9; i >= 0; i--) {
            red = i / 10.0;
            green = ((i + 3) % 10) / 10.0;
            blue = ((i + 6) % 10) / 10.0;
            Thread::wait(100);  
        }

    }
}

void lcdStart(void const *args) {
    while(1) { 
        for (int i = 59; i >= 0; i--) {
            mutex.lock();   
            uLCD.locate(2,2);
            uLCD.printf("%2d", i);
            mutex.unlock();
            Thread::wait(100);     
        }
    }
}

void lcdEnd(void const *args) {
    while(1) {
        for (int i = 0; i <= 59; i++) {
            mutex.lock();
            uLCD.locate(0,0);
            uLCD.printf("%2d", i);
            mutex.unlock();
            Thread::wait(100);
        }
    }
}

void dev_recv()
{
    led1 = !led1;
    while(dev.readable()) {
        mutex.lock();
        pc.putc(dev.getc());
        mutex.unlock();
    }
}

void receive(void const *args) {
    char bnum=0;
    char bhit=0;
    while(1) {
        Thread::wait(20);
        mutex.lock();
        if (dev.getc()=='!') {
            if (dev.getc()=='B') { //button data packet
                bnum = dev.getc(); //button number
                bhit = dev.getc(); //1=hit, 0=release
                if (dev.getc()==char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                    myled = bnum - '0'; //current button number will appear on LEDs
                    switch (bnum) {
                        case '1': //number button 1
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        case '2': //number button 2
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        case '3': //number button 3
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        case '4': //number button 4
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        case '5': //button 5 up arrow
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        case '6': //button 6 down arrow
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        case '7': //button 7 left arrow
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        case '8': //button 8 right arrow
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                //add release code here
                            }
                            break;
                        default:
                            break;
                    }
                }
            }
        }
        mutex.unlock();
    }
}

void pc_recv()
{
    led4 = !led4;
    while(pc.readable()) {
        mutex.lock();
        dev.putc(pc.getc());
        mutex.unlock();
    }
}


int main() {
    
    Thread thread1(rgb);
    Thread thread2(lcdStart);
    Thread thread3(lcdEnd);
    Thread thread4(receive);
    
    while(1) {
        FILE *wave_file;
        wave_file = fopen("/sd/Music.wav", "r");
        waver.play(wave_file);
        fclose(wave_file);
    }
}
