#include "userMethods.h"
#include "sensor.h"
#include <cstring>
#include <ctime>
#include <stdexcept>
#include <vector>

//FIFO buffer
vector<log_data> * logVector;
int * UserMethods::n;
ExpansionBoard * UserMethods::e;
bool UserMethods::flag;
Mail<log_data, QUEUESIZE> * logMail;

// Method that processes the ReadAll command
void UserMethods::readAllData(const void*)
{
    printf("Chegei");
    vector<log_data> vector = *logVector;

    if(flag) printf("Entered in readAllData");
    
    char buffer[32];

    //.csv header
    if(flag) printf("Sample_Date,HTS221_Temp,LPS25H_Press,HTS221_Hum\n\r");
    
    for(int i = 0; i < vector.size(); i++)
        //TODO Add time here and read n
        //.csv friendly format for logging
        printf("%s,%7s°C,%smbar,%s%%\n\r", ctime(&vector[i].date), ExpansionBoard::printDouble(buffer, vector[i].tempCelsius, 2),
               ExpansionBoard::printDouble(buffer, vector[i].pressure, 2), ExpansionBoard::printDouble(buffer, vector[i].humidity, 2));
               
        Thread::wait(1000);
}

// Method to proccess Read <n> command 
void UserMethods::readNData(const void*)
{
    vector<log_data> vector = *logVector;
    int num = *n;

    if(flag) printf("Sample_Date,HTS221_Temp,LPS25H_Press,HTS221_Hum\n\r");
    
    char buffer[32];
    for(int i = vector.size()-num-1; i < vector.size(); i++)
        printf("%s,%7s°C,%smbar,%s%%\n\r", ctime(&vector[i].date), ExpansionBoard::printDouble(buffer, vector[i].tempCelsius, 2),
               ExpansionBoard::printDouble(buffer, vector[i].pressure, 2), ExpansionBoard::printDouble(buffer, vector[i].humidity, 2));
}

// Method that proccesses the DeleteAll command
int UserMethods::deleteAllData(const void*)
{
    vector<log_data> vector = *logVector;
    Mail<log_data, QUEUESIZE> mail = *logMail;
    int num = vector.size();
    ExpansionBoard sensor = *e;

    for(int i = 0; i < vector.size(); i++) {
        osEvent evt = mail.get();
        if (evt.status == osEventMail) {
            log_data *log = (log_data*)evt.value.p;
            mail.free(log);
        }
    }

    vector.clear();

    return num;
}

// Method thar proccesses the Read<n> command 
int UserMethods::deleteNData(const void*)
{/*
    vector<log_data> vector = *v;
    int num = (int)vector.size();
    int nOfRecords = *n;
    ExpansionBoard sensor = *e;

    if(nOfRecords >= num) {
        //nOfRecords = UserMethods::deleteAllData;
        return nOfRecords;
    } else {
        for(int i = 0; i < nOfRecords; i++) {
            osEvent evt = sensor.mail_box.get();
            if (evt.status == osEventMail) {
                log_data *log = (log_data*)evt.value.p;
                sensor.mail_box.free(log);
            }
        }
        //Erases the first n elements
        //vector.erase(v.begin(), v.begin() + nOfRecords);
    }

    return nOfRecords;
    */
    return 0;
}

// Constructor of the class 
UserMethods::UserMethods(vector<log_data> vector, int num, ExpansionBoard sensor, bool lFlag, Mail<log_data, QUEUESIZE> mail)
{
    logVector = &vector;
    n = &num;
    e = &sensor;
    flag = &lFlag;
}