#ifndef EXPANSIONBOARD_H
#define EXPANSIONBOARD_H

#include "rtos.h"
#include "x_nucleo_iks01a1.h"
#include <vector>

using std::vector;

#define QUEUESIZE 120

/* Instantiate the expansion board */
static X_NUCLEO_IKS01A1 *mems_expansion_board = X_NUCLEO_IKS01A1::Instance(D14, D15);

static GyroSensor *gyroscope = mems_expansion_board->GetGyroscope();
static MotionSensor *accelerometer = mems_expansion_board->GetAccelerometer();
static MagneticSensor *magnetometer = mems_expansion_board->magnetometer;
static HumiditySensor *humidity_sensor = mems_expansion_board->ht_sensor;
static PressureSensor *pressure_sensor = mems_expansion_board->pt_sensor;
static TempSensor *temp_sensor = mems_expansion_board->ht_sensor;


// Class that will store the log information 
class ExpansionBoard
{
public:
    ExpansionBoard(int num, bool lFlag);
    static void sampleData();
    static void getData(const void*);
    //static Queue<log_data, QUEUESIZE> queue;
    static char *ExpansionBoard::printDouble(char* str, double v, int decimalDigits);
    float T;                       //Default sampling rate, specified in specs
    //static vector<log_data> v;
    static int * n;
    static bool flag;
};

#endif