/**
 ******************************************************************************
 * @file    main.cpp
 * @author  ANG Group (Nelson Santos; Irina Baptista; Pierluigi Urru)
 * @version V0.0.3
 * @brief   Simple Example application for using the X_NUCLEO_IKS01A1
 *          MEMS Inertial & Environmental Sensor Nucleo expansion board.
 ******************************************************************************
*/

#include "mbed.h"
#include "x_nucleo_iks01a1.h"
#include "rtos.h"
#include <cstring>
#include <stdexcept>
#include <vector>
#include "sensor.h"
#include "userMethods.h"
#include "log.h"

#define QUEUESIZE 120

struct tm t = {t.tm_hour = 0};

int n = 0;
bool flag = false;

Mail<log_data, QUEUESIZE> mail_box;
vector<log_data> v;

ExpansionBoard e(n, flag);
UserMethods u(v, n, e, flag, mail_box);

int i = 0;

void sampleData()
{
    //while(true){
    if(flag) printf("\nAbout to alloc\n");
    log_data *log_d = mail_box.alloc();

    if (log_d == NULL) {
        if(flag) printf("Out of memory, last sample deleted\n");
        osEvent evt = mail_box.get();
        log_data *log = (log_data*)evt.value.p;
        printf("\nI = %d\n", i);
        printf("Pressure: %f", log->pressure);
        printf("Counter: %d", log->counter);
        log_data* log_d = (log_data*)mail_box.alloc();
        if(flag) printf("Allocated after out of memory\n");
    }

    if(flag) printf("Not null, reading values\n");
    //Store read data in a sample
    float value;
    //log_d->date = time(NULL);
    temp_sensor->GetTemperature(&value);
    log_d->tempCelsius = value;
    humidity_sensor->GetHumidity(&value);
    log_d->humidity = value;
    pressure_sensor->GetPressure(&value);
    log_d->pressure = value;
    log_d->counter = i;
    if(flag) printf("All values STORED\n");
    //Send pointer to sample to the queue
    //osStatus stat = 
    mail_box.put(log_d);
    Thread::wait(4000);
    
    i++;
    
    //v.push_back(*log_d);

    if(flag) printf("MAIL_BOX.PUT run\n");
    //printf("%d", v.size());
  //  printf("Pressure: %f, Humidity: %f", v[0].pressure, v[0].humidity);
    // Check for resource error
  /*  if (stat == osErrorResource) {
        if(flag) printf("mail_box->put() Error %4Xh\n", stat);
        //Error, free up memory block taken
        mail_box.free(log_d);
      
    }*/
   // Thread::wait(1000);
    //}
}

int main()
{
    printf("Sampling started...\n");

    printf("\n\rWelcome! Type one of the following commands and press space or enter");
    printf("\n\r Don't forget to use only capitals when typing the commands!");
    printf("\n\r READ ALL\n\r READ <n>\n\r DELETE ALL\n\r DELETE <n>");
    printf("\n\r SETDATE dd mm yyyy\n\r SETTIME hh mm ss");
    printf("\n\r SETT <T>\n\r STATE <x>\n\r LOGGING <x>\n\r EXIT\n\n\r");

    //Initialise time
    set_time(0);

    //ISR to sample data
    Ticker ticker;
    ticker.attach(&sampleData, e.T);

    char command[20];
    char arg[10];

    //User commands

    while(1) {
        scanf("%s", command);

        if (strcmp("READ", command)==0) {
            scanf("%s", arg);
            printf("\n");
            if(strcmp("ALL", arg)==0)
                Thread readAllThread(u.readAllData, NULL, osPriorityNormal, DEFAULT_STACK_SIZE);

            else if (atoi(arg)!= 0) {
                n = atoi(arg); //A bit hacky, but it works
                Thread  readThread(u.readNData, NULL,osPriorityBelowNormal, DEFAULT_STACK_SIZE);
            }

            else perror("The argument is invalid\n\r");
        }

        else if (strcmp("DELETE", command)==0) {
            scanf("%s", arg);
            printf("\n");
            if (strcmp("ALL", arg)==0) {
                //int n = v.size();
                //v.clear();
                printf("DELETED %d RECORDS", n);
            } else if (atoi(arg)!= 0) {
                /*int n = v.size();
                v.erase(v.begin(), v.end());
                if(n < atoi(arg))
                  */  printf("DELETED %d RECORDS", n);
                //else printf("DELETED %d RECORDS", atoi(arg));
            }

            else perror("The argument is invalid\n\r");
        }
        
        else if (strcmp("SETDATE", command)==0) {
            char day[2], month[2], year[4];
            //Read day
            scanf("%s", day);
            if (atoi(day)!=0)
                atoi(day)<31 ? t.tm_mday=atoi(day) : printf("Invalid day\n");
            // Read month
            scanf("%s", month);
            if (atoi(month)!=0)
                atoi(month)<=12 ? t.tm_mon=atoi(month)-1 : printf("Invalid month\n");
            //Read year
            scanf("%s", year);
            printf("\n");
            if (atoi(year)!=0)
                atoi(year)>=70 ? t.tm_year=atoi(year)-1900 : printf("Invalid year\n");

            // Check whether date is correct
            if (mktime(&t)>0) {
                printf("DATE UPDATED TO %d %d %d", t.tm_mday,
                       t.tm_mon+1, t.tm_year+1900);
                set_time(mktime(&t));
            } else perror("Date inserted is invalid\n\r");
        }

        else if (strcmp("SETTIME", command)==0) {
            char hour[2], min[2], sec[2];

            scanf("%s", hour);
            if (atoi(hour)!=0)
                t.tm_hour = atoi(hour);
            scanf("%s", min);
            if (atoi(min)!=0)
                t.tm_min = atoi(min);
            scanf("%s", sec);
            if (atoi(sec)!=0)
                t.tm_sec = atoi(sec);
            printf("\n");

            //If the user sets this before without DATE, it's gonna be garbage

            // Check whether time is correct
            if (mktime(&t)>0) {
                set_time(mktime(&t));
                printf("TIME UPDATED TO %d %d %d", t.tm_hour, t.tm_min, t.tm_sec);
            } else perror("Time inserted is invalid\n\r");
        }

        // Set sampling period
        else if (strcmp("SETT", command)==0) {
            scanf("%s", arg);
            printf("\n");
            if (atof(arg) >= 0.1 && atof(arg) <= 60.0 ) {
                e.T = atof(arg);
                ticker.attach(sampleData,e.T);
                printf("T UPDATED TO %.1f", e.T);
            } else perror ("Value must be between 1 and 60");

            //Toggle sampling on and off

        } else if (strcmp("STATE", command)==0) {
            scanf("%s", arg);
            printf("\n");
            if (strcmp("ON", arg)==0) {
                ticker.attach(sampleData, e.T);
                printf("SAMPLING ON");
            } else if (strcmp("OFF", arg)==0) {
                ticker.detach();
                printf("SAMPLIG OFF");
            }

            else perror("The argument is invalid\n\r");
        }

        //Toggle debug messages  on and off
        else if(strcmp("LOGGING", command)==0) {
            scanf("%s", arg);
            printf("\n");
            if (strcmp("ON", arg)==0){
                printf("Diagnostics ON");
                flag= true;
                
                }
            else if (strcmp("OFF", arg)==0){
                
                printf("Diagnostics OFF");
                flag= false;
                
                }
            else perror ("The argument is invalid\n\r");
        }


        else if(strcmp("EXIT", command) == 0) {
            break;
        }

        else perror("\nThere is no command matching. Try again");

        // Clear the input to avoid it to being reused in the next cycle
        command[0] = arg[0] = 0;
        printf("\n\r");
    }


    printf ("Thank you for using our system \n");
    printf ("\n Press the reset button to start again \n");

    return 0;
}
