#include "mailBox.cpp"
#include "expansionBoard.cpp"

struct tm t;

 class UserMethods {
  
  public: 
         
    int readAll() {
        ExpansionBoard logs;
        int nOfRecords = logs.count;
        
        while(nOfRecords > 0) {
            osEvent evt = mail_box.get();

            if (evt.status == osEventMail) {
                log_data* log = (log_data*)evt.value.p;
                printf("Record %d \nDate: %s, Temp Celcius: %f, Temp Farenheit: %f, Humidity: %f, "
                           "Pressure: %f, Accelerometer: %d, Gyroscope: %d, Magnetometer: %d\n\n", log->id,
                           log->date, log->tempCelsius, log->tempFarenheit, log->humidity,
                           log->pressure, log->accelerometer, log->gyroscope, log->magnetometer);

                nOfRecords--;
            }
        }
        
        return logs.count;
    }

    int deleteAll() {
        ExpansionBoard logs;
        int n = logs.count;

        while(n > 0) {
            osEvent evt = mail_box.get();
            if (evt.status == osEventMail) {
                log_data *log_d = (log_data*)evt.value.p;
                mail_box.free(log_d);
            }
            n--;
        }
        return logs.count;
    }

    int readN(int n) {
        ExpansionBoard logs;
        int nOfRecords = 0;

        if(logs.count < n) {
            nOfRecords = readAll();
        } else {
            while(nOfRecords < n) {
                osEvent evt = mail_box.get();
                
                if (evt.status == osEventMail) {
                    log_data* log = (log_data*)evt.value.p;
                    printf("Record %d \nDate: %s, Temp Celcius: %f, Temp Farenheit: %f, Humidity: %f, "
                           "Pressure: %f, Accelerometer: %d, Gyroscope: %d, Magnetometer: %d\n\n", log->id,
                           log->date, log->tempCelsius, log->tempFarenheit, log->humidity,
                           log->pressure, log->accelerometer, log->gyroscope, log->magnetometer);

                    nOfRecords--;
                }
            }
        }
        
        return nOfRecords;
    }

    int deleteN(int n) {
        ExpansionBoard logs;
        
        if(logs.count < n){
            n = deleteAll();
        } else {
            while(n > 0) {
                osEvent evt = mail_box.get();
                if (evt.status == osEventMail) {
                    log_data *log_d = (log_data*)evt.value.p;
                    mail_box.free(log_d);
                }
                n--;
            }
        }
        return n;
    }

    bool setDate() {
        bool success;
        printf("Enter current date : \n");
        printf( "YYYY MM DD [enter] \n");
        scanf ("%d %d %d", &t.tm_year, &t.tm_mon, &t.tm_mday);

        // adjust for tm structure required values
        t.tm_year = t.tm_year - 1900;
        t.tm_mon = t.tm_mon - 1;
        // set the time
        set_time(mktime(&t));
        success= true;

        return success;
    }

    bool setTime () {
        bool success = false;

        // get the current time from the terminal
        printf("Enter current time:\n");
        printf("HH MM SS[enter]\n");
        scanf("%d %d %d", &t.tm_hour, &t.tm_min, &t.tm_sec);

        printf("TIME UPDATED TO %d:%d:%d\n", t.tm_hour, t.tm_min, t.tm_sec);

        // set the time
        set_time(mktime(&t));
        success = true;

        return success;
    }

    void setT(int timePeriod) {
        scanf("Enter sampling period: %d\n", &timePeriod);
    }
    /*
    void state(char x){
        printf("Sampling is %s\n", x);
        printf("Enter state:\n");
        scanf("%s", x);
    }*/

    bool logTime (int time, bool state) {
        return state;
    }

    bool debugMessages (bool state) {
        return state;
    }

    bool  logging(bool state) {
        return state;
    }
       
 };