/**
 ******************************************************************************
 * @file    main.cpp
 * @author  ANG Group (Nelson Santos; Irina Baptista; Pierluigi Urru)
 * @version V0.0.1
 * @date    05-May-2016
 * @brief   Simple Example application for using the X_NUCLEO_IKS01A1
 *          MEMS Inertial & Environmental Sensor Nucleo expansion board.
 ******************************************************************************
*/

#include "mbed.h"
#include "x_nucleo_iks01a1.h"
#include "expansionBoard.cpp"
#include <cstring>
#include <ctime>
#include <stdexcept>

ExpansionBoard e;
struct tm t;
//Thread *t;

void getData(const void*){
    while(true){
        //Block on queuefor at most 5s if no data is available
        osEvent event = mail_box.get(5000);
        
        if(event.status == osEventTimeout) {
            printf("mail_box.get %02x, Timeout error", event.status);
            return;
        }
        else if (event.status == osEventMail) {
            // Successful, store log_data
            //TODO Store it somewhere
            log_data *log_d = (log_data*)event.value.p;
            mail_box.free(log_d);
        }
    }
}

int main() {

    char command[20];
    char arg[10];

    printf("\n\rWelcome! Type one of the following commands");
    printf("\n\r READ ALL\n\r READ <n>\n\r DELETE ALL\n\r DELETE <n>");
    printf("\n\r SETDATE dd mm yyyy\n\r SETTIME hh mm ss");
    printf("\n\r SETT <T>\n\r STATE <x>\n\r LOGGING <x>");

    scanf("%s", command);

    if (strcmp("READ", command)==0) {
        scanf("%s", arg);
        if(strcmp("ALL", arg)==0)
            //readAllSamples()
            printf("You ended up in READ ALL");
        else if (atoi(arg)!= 0)
            //readSample(atoi(arg));
            printf("You ended up in READ <n>");
        else printf("The argument is invalid");
    }
    else if (strcmp("DELETE", command)==0) {
        scanf("%s", arg);
        if (strcmp("ALL", arg)==0)
            //deleteAllSamplesOrSomething()
            printf("You ended up in READ ALL");
        else if (atoi(arg)!= 0)
            //deleteSample(atoi(arg));
            printf("You ended up in DELETE <n>");
        else printf("The argument is invalid");
    }
    else if (strcmp("SETDATE", command)==0) {
        char day[2], month[2], year[4];

        //Read day
        scanf("%s", day);
        if (atoi(day)!=0)
            t.tm_mday = atoi(day);
        // Read month
        scanf("%s", month);
        if (atoi(month)!=0)
            t.tm_mon = atoi(month)-1;
        //Read year
        scanf("%s", year);
        if (atoi(year)!=0)
            t.tm_year = atoi(year)-1900;

        // Check whether date is correct
        if (mktime(&t)>0) {
            printf("DATE UPDATED TO %d %d %d", t.tm_mday,
                   t.tm_mon+1, t.tm_year+1900);
            set_time(mktime(&t));
        }
        else printf("Time inserted is invalid");
    }
    else if (strcmp("SETTIME", command)==0) {
        char hour[2], min[2], sec[2];

        scanf("%s", hour);
        if (atoi(hour)!=0)
            t.tm_hour = atoi(hour);
        scanf("%s", min);
        if (atoi(min)!=0)
            t.tm_min = atoi(min);
        scanf("%s", sec);
        if (atoi(sec)!=0)
            t.tm_sec = atoi(sec);

        //If the user sets this before without DATE, it's gonna be garbage

        // Check whether time is correct
        if (mktime(&t)>0) {
            set_time(mktime(&t));
            printf("TIME UPDATED TO %d %d %d", t.tm_hour,
                   t.tm_min, t.tm_sec);
        }
        else printf("Time inserted is invalid");
    }
    else if (strcmp("SETT", command)==0) {
        scanf("%s", arg);
        if (atof(arg) >= 0.1 && atof(arg) <= 60.0 ) {
            e.T = atof(arg);
            printf("T UPDATED TO %.1f", e.T);
        }
        //else throw std::out_of_range ("T MUST BE WITHIN 0.1 AND 60.0");
    }
    else if (strcmp("STATE", command)==0) {
        scanf("%s", arg);
        if (strcmp("ON", arg)==0)
            //TODO For now it just reads data and prints it out, FIFO needed
            e.startSampling();
        else if (strcmp("OFF", arg)==0)
            e.stopSampling();
        else printf("The argument is invalid");
    }
    else if(strcmp("LOGGING", command)==0) {
        scanf("%s", arg);
        if (strcmp("ON", arg)==0){
            //startLogging();
            printf("LOGGING ON");
        }
        else if (strcmp("OFF", arg)==0){
            //stopLogging();
            printf("LOGGING OFF");
        }
        else printf("The argument is invalid");
    }
    else printf("There is no command matching. Please try again");

    // Clear the input to avoid it to being reused in the next cycle
    command[0] = arg[0] = 0;

    return 0;
}