#include "mbed.h"
#include "rtos.h"
#include "string.h"
#include <stdio.h>
#include <ctype.h>

// A First-In-First-Out buffer is used with streams of data.
// It is thread-safe and often used to buffer data across threads

#define BUFFERSIZE 100
/*
typedef struct {
        uint8_t   id;
        float    tempCelsius;
        float    tempFarenheit;
        float    humidity;
        float    pressure;
        int32_t  accelerometer[3];
        int32_t  gyroscope[3];
        int32_t  magnetometer[3];
        char*    date;
    } log_data;

Semaphore *spaceAvailable;
Semaphore *samplesInBuffer;
Mutex *bufferLock;

log_data buffer[BUFFERSIZE];
unsigned int newestIndex = BUFFERSIZE-1;
unsigned int oldestIndex = BUFFERSIZE-1;

class Buffer {
public:
    void addDataToQueue(log_data d) {
    // Check whether there's space
    int32_t Nspaces = spaceAvailable->wait();
    
    // If there's space, use the mutex
    bufferLock->lock();
    
    // Update buffer
    newestIndex = (newestIndex+1) % BUFFERSIZE;
    buffer[newestIndex] = d;
    printf("\tAdded log_data id %d to buffer, %d space available\n",
        unsigned(d.id), Nspaces-1);
    
    bufferLock->unlock();
    
    // Signal that a sample has been added
    samplesInBuffer->release();
    }
    
    log_data takeCharacterFromQueue(){
    // Check whether there are samples
    int32_t Nsamples = samplesInBuffer->wait();
    
    bufferLock->lock();
    
    oldestIndex = (oldestIndex+1) % BUFFERSIZE;
    log_data d = buffer[oldestIndex];
    printf("\tRemoved log_data id %d from buffer, %d bytes remaining\n",
        unsigned(d.id), Nsamples-1);
    
    bufferLock->unlock();
    
    //Signal there's space in the buffer
    spaceAvailable->release();
    
    return d;
    }
    
    Buffer() {
        bufferLock = new Mutex();
        spaceAvailable = new Semaphore(BUFFERSIZE);
        samplesInBuffer = new Semaphore(0);
    }
};
*/