// Anexo 2: Programa para excitar o conversor e realizar a identificação do sistema

#include "mbed.h"
#include "Sinal.h"
#include "FastPWM.h"

Ticker aciona_interrupcao;

Serial pc(SERIAL_TX, SERIAL_RX, 1000000);

AnalogIn tensao_entrada(A4);
AnalogIn tensao_saida(A5);

FastPWM fastpwm(PB_4,1);

DigitalOut carga(PB_5);
DigitalOut L_8V(PB_3);

static int interrupt = 1, k=0, periodo_pwm = 1;
float T = 0.001;

float le_tensao_vin(){
    return tensao_entrada.read()*11.5;
    }
    
float le_tensao_vout(){
    return tensao_saida.read()*11.5;
    }

void liga_8V(){
    L_8V = 1;wait(T/5);
    }

void interrupcao(){
    interrupt = 1;
    k=k+1;
}

void inicio(){
    wait(0.5);
    aciona_interrupcao.attach(&interrupcao, T);
    
    fastpwm.period_ticks (5000);                    // Ajusta o período do pwm para 20Khz (5000 system ticks)
    fastpwm.pulsewidth_ticks(0);                    // Ajusta o ciclo de trabalho
    
    pc.printf("%% Inicio do programa");  
    pc.printf("\nclear all; clc;");  
    pc.printf("\ndados = [");      
}

void imprime_dados(float u, float vout){
    pc.printf("\n%d", k);    
    pc.printf("     ");
    pc.printf("%f", u);    
    pc.printf("     ");  
    pc.printf("%f", vout);  
}

void fim(){   
    pc.printf("];");
    pc.printf("\nfigure(1)");
    
    pc.printf("\nsubplot(2,1,1)");
    pc.printf("\nstairs(dados(:,3),'k')");    
    pc.printf("\ngrid on");
    pc.printf("\nylabel('Tensão de saida')");
    pc.printf("\naxis([0 5000 0 10])");
    
    pc.printf("\nsubplot(2,1,2)");    
    pc.printf("\nstairs(dados(:,2))");
    pc.printf("\ngrid on");
    pc.printf("\nylabel('controle')");
    pc.printf("\naxis([0 5000 0 5000])");
    
    pc.printf("\nsave dados dados");
    
    fastpwm.pulsewidth_ticks(0);     // Ajusta o ciclo de trabalho
    
    while(1){ }  
}

float seta_pwm(int x){
        if(x==0) x=1000;
        if(x==1) x=4000;
    
    fastpwm.pulsewidth_ticks(x);     // Ajusta o ciclo de trabalho
    return x;
        }


int main() {
    int i = 0;
    float vin=0.0,vout=0.0, u=0.0;
        
    inicio();
    
    liga_8V();
    
    while(1){
        
    if(interrupt) {
        
        u = seta_pwm(sinal_pwm[k]);        
           
        imprime_dados(u, le_tensao_vout());
        
        
        interrupt = 0;
        
        if(k==tam-1) fim();
            
      
    }
    

}
}