// Anexo 4: Programa principal com controle do conversor implementado
#include "mbed.h"
#include "FastPWM.h"

Ticker aciona_interrupcao;

Serial pc(SERIAL_TX, SERIAL_RX, 1000000);

AnalogIn tensao_entrada(PC_1);                      
AnalogIn tensao_saida(PC_0);                        

FastPWM fastpwm(PB_4,1);

DigitalOut carga(PB_5);
DigitalOut L_8V(PB_3);

static int interrupt = 1, k=0, L = 3000;
float T = 0.001;
float r = 5.0;

float kp = 50;
float ki = 1;
float kd = 0.1;

float le_tensao_vin(){
    return tensao_entrada.read()*11.5;
    }
    
float le_tensao_vout(){
    return tensao_saida.read()*11.5;
    }

void liga_8V(){
    L_8V = 1;wait(T/5);
    }
    
void liga_12V(){
    L_8V = 0;wait(T/5);
    }

float seta_pwm(int x){
        
    if(x<0) x=0;
    if(x>5000) x=5000;  
    fastpwm.pulsewidth_ticks(x);     // Ajusta o ciclo de trabalho
    return x;
}

void interrupcao(){
    interrupt = 1;
    k=k+1;
}

void inicio(){
    wait(0.5);
    aciona_interrupcao.attach(&interrupcao, T);
    
    fastpwm.period_ticks (5000);                    // Ajusta o período do pwm para 20Khz (5000 system ticks)
    fastpwm.pulsewidth_ticks(0);                    // Ajusta o ciclo de trabalho
    
    pc.printf("%% Inicio do programa");  
    pc.printf("\nclear all; clc;");  
    pc.printf("\ndados = [");      
}

void imprime_dados(int u, float vin, float vout, float Rcarga_out){
    pc.printf("\n%d", k);    
    pc.printf("     ");
    
    pc.printf("%d", u);    
    pc.printf("     ");
    
    pc.printf("%f", vin);    
    pc.printf("     ");  
    
    pc.printf("%f", vout);  
    pc.printf("     ");
    
    pc.printf("%f", Rcarga_out);
}

void fim(){   
    pc.printf("];");
    pc.printf("\nfigure(1)");
    
    pc.printf("\nsubplot(4,1,1)");
    pc.printf("\nstairs(dados(:,4),'k')");
    pc.printf("\ngrid on");    
    pc.printf("\nylabel('Tensão de saida (V)')");
    pc.printf("\naxis([0 3000 0 10])");
    
    pc.printf("\nsubplot(4,1,2)");    
    pc.printf("\nstairs(dados(:,3))");
    pc.printf("\ngrid on");
    pc.printf("\nylabel('Tensão de entrada (V)')"); 
    pc.printf("\naxis([0 3000 0 14])"); 
    
    pc.printf("\nsubplot(4,1,3)");    
    pc.printf("\nstairs(dados(:,5))");
    pc.printf("\ngrid on");
    pc.printf("\nylabel('Degrau de carga (OHMS)')"); 
    pc.printf("\naxis([0 3000 0 30])"); 
    
    pc.printf("\nsubplot(4,1,4)");  
    pc.printf("\nstairs(dados(:,2))");
    pc.printf("\ngrid on");
    pc.printf("\nylabel('CONTROLE')");
    pc.printf("\naxis([0 3000 0 5500])");
    pc.printf("\nxlabel('Amostra [k]')");
    
    pc.printf("\nsave dados dados\n\n");
    fastpwm.pulsewidth_ticks(0);     // Ajusta o ciclo de trabalho
    
    while(1){ }  
}

int main() {
    int i = 0, u = 0;
    float vin=0.0,vout=0.0, Rcarga = 22, e = 0, e0 = 0;
    
    inicio();
        
    while(1){
        
    if(interrupt) {
        vin = le_tensao_vin();
        vout = le_tensao_vout();
        
        /****** Implementação PID *********/
                
        e = r - vout;
        
        u = (kp*e) + (u+ki*T*e) + (kd*(e-e0)/T);
        
        e0 = e;
        /**********************************/
        
        seta_pwm(u);  
                   
        imprime_dados(u,vin,vout,Rcarga);
        interrupt = 0;
        
        if(k==1000)liga_8V();
        if(k==2000){carga = 1; Rcarga = 5.6;}
        if(k==L)fim();
      
    }
}
}