//Thermostat class
//Napoleon Leoni
//Thermostat with Joystick control input
//Class Thermostat: 
//Has a control loop enable/disable(I will refer to this as Heater on/off), an over-ride enable/disable.
//an object TemperatureRecording (keeps current temperature, max and min since last reset 
//and circular buffer with recorded data)
//Functions to check user input on joystick
//sets interrupt on accelerometer (To be implemented)

//***************************** TESTING ********************************************************//
//  TEST        TEST DESCRIPTION                                                STATUS          //
//  1           Time display is inceremented in seconds and date shown          PASS            //
//              corresponds to date set in code                                                 //
//  2           Joystick input works as expected up/down to increase            PASS            //
//              decrease the temperature settting by the selected                               //
//              granularity and left/right to turn heater on/off                                //
//              LCD display shows correct changes in values as well                             //
//  3           Automated thermostatCycle test includes feeding a known         PASS            //
//              array of temperatures and verifying sample by sample that                       //
//              the thermostat loop is enabled when it should be. this loop                     //
//              also checks what happens when the heater is set to on or off                    //
//              this test issues a PASS status only if the results are correct                  //
//              for every sample
//**********************************************************************************************//

#include "mbed.h"
#include "LM75B.h"
#include "temperatureRecorder.h"
#include "joystickAppBoard.h"

#ifndef THERMOSTAT
#define THERMOSTAT
#define DEFAULTHYSTERESYS  5 //degrees F, dead band of controller to prevent excessive turn on/off
#define DEFAULTGRANULARITY 2 //degrees F, increment in temperaure setting per joystick click
#define DEFAULTTEMPSETTING 60 //degrees F, default setting for thermostat
#define DEFAULTMAXTEMPSETTING 96     //degrees F, max temperature setting to avoid user over shooting setting with joystick
#define DEFAULTMINTEMPSETTING 44     //degrees F, min temperature setting to avoid user under shooting setting with joystick
#define DEFAULTTIME 

class thermostat{
    //public members
    public:
    //private members
    private:
        temperatureRecorder *trecord;       //pointer to TemperatureRecordeObject
        joystickAppBoard *inputJoystick;    //pointer to input joystick object
        DigitalOut *actuatorOutput;         //pointer to Digital Output for actuator, this would run the relay for the heater
                                            //temporarily we could use an LED as output so that the heating action is signaled
                                            //by the turning on and off of an LED
        struct tm timeKeeper;               //structure to hold date/time type
        time_t timeInSeconds;               //variable to keep absolute time
        float hysteresisGap, temperatureGranularity, defaultTemperature, maxTemperature, minTemperature;
        bool heaterEnabled;     //This flag corresponds to whether the thermostat control is on
        bool heatingActionOn;   //this flag corresponds to whether the thermostat has turned the heating action (relay) on
    //public methods
    public:
        thermostat();//default constructor
        thermostat(temperatureRecorder *,joystickAppBoard *,DigitalOut *);//regular constructor
        void enableHeater(void);
        void disableHeater(void);
        void checkJoystickInput(void);
        void runThermostatControlCycle(void);
        float getTemperature(void);//Read current temperature
        float getMaxTemperature(void);//read Maximum Temperature
        float getMinTemperature(void);//read Maximum Temperature
        float getTemperatureSetting(void); //read temperature setting
        bool getThermostatStatus(void); //returns true if heaterEnabled, that is thermostat control is on
        void setDay(int,int,int);
        void setTime(int,int,int);
        void getDateandTime(char*,int); //return Date and time as a formatted string in the provided char buffer
        void ThermostatUnitTest(char *,int);//unit test for thermostat class, injects a synthetic temperature to test the operation
    //private methods
    private:
}; //end of thermostat class prototype 
#endif
