#include "thermostat.h"
//Thermostat class
//Napoleon Leoni
//Thermostat with Joystick control input
//Class Thermostat: 
//Has a control loop enable/disable(I will refer to this as Heater on/off), an over-ride enable/disable.
//an object TemperatureRecording (keeps current temperature, max and min since last reset 
//and circular buffer with recorded data)
//Functions to check user input on joystick
//sets interrupt on accelerometer (To be implemented)

//regular constructor
thermostat::thermostat(temperatureRecorder *ptrTrecord,joystickAppBoard *ptrinputJoystick,DigitalOut *ptrActuatorOutput){
    //initialize class pointers and default settings
    this->trecord=ptrTrecord;
    this->trecord->setTemperatureToFarenheit(); //by default our thermostat will be in Farenheit
    this->inputJoystick=ptrinputJoystick;
    this->actuatorOutput=ptrActuatorOutput;
    this->hysteresisGap=DEFAULTHYSTERESYS;
    this->temperatureGranularity=DEFAULTGRANULARITY, 
    this->defaultTemperature=DEFAULTTEMPSETTING;
    this->maxTemperature=DEFAULTMAXTEMPSETTING;
    this->minTemperature=DEFAULTMINTEMPSETTING;
    this->heaterEnabled=false;
    // set the time
    
    set_time(1256729737); //set default valid value to initialize
    timeInSeconds = time(&(this->timeInSeconds));//Update time to current time
}

void thermostat::setDay(int month,int day,int year){
    //Note to be implemented, Protection against out of range or invalid inputs
    this->timeKeeper.tm_year=year;
    this->timeKeeper.tm_year = this->timeKeeper.tm_year - 1900;
    this->timeKeeper.tm_mon=month-1;
    this->timeKeeper.tm_mday=day;
    set_time(mktime(&(this->timeKeeper)));
}

void thermostat::setTime(int hour,int min,int sec){
    //Note to be implemented, Protection against out of range or invalid inputs
    this->timeKeeper.tm_hour=hour;
    this->timeKeeper.tm_min=min;
    this->timeKeeper.tm_sec=sec;
    set_time(mktime(&(this->timeKeeper)));
}

//retutns the day and time as a string
void thermostat::getDateandTime(char* buffer,int bufferSize){
    //TODO: check size of inout buffer and reject if smaller than minimum required
    timeInSeconds = time(&(this->timeInSeconds));//Update time to current time
    strftime(buffer, bufferSize, "%c\n", localtime(&(this->timeInSeconds)));
}

void thermostat::enableHeater(void){
    this->heaterEnabled=true;
}

void thermostat::disableHeater(void){
    this->heaterEnabled=false;
    this->heatingActionOn=false;        //turn off relay indicator as well as the thermostat is disabled
    this->actuatorOutput->write(0);     //turn off relay as well as the thermostat is disabled
}

void thermostat::checkJoystickInput(void){
    this->inputJoystick->readJoystick();
    if(this->inputJoystick->isJoystickUp()){
         if(this->defaultTemperature<this->maxTemperature){
            this->defaultTemperature+=this->temperatureGranularity;//increase temp. setting 
         } 
    }
    if(this->inputJoystick->isJoystickDown()){
        if(this->defaultTemperature>this->minTemperature){
            this->defaultTemperature-=this->temperatureGranularity;//decrease temp. setting   
        }
    }
    if(this->inputJoystick->isJoystickLeft()){
         this->disableHeater();//disable heater   
    }
    if(this->inputJoystick->isJoystickRight()){
         this->enableHeater();//enable heater   
    }
    
}

void thermostat::runThermostatControlCycle(void){
    //First read temperature values
    this->trecord->makeReading(); //Make temperature reading;
    if(this->heaterEnabled){ //the Thermostat heating loop is only run if it is enabled
        //next compare aginst target within +/- 1/2 Hysteresis Gap window    
        if(this->trecord->getTemperature() < (this->defaultTemperature - 0.5*hysteresisGap)){
            this->heatingActionOn=true;
            this->actuatorOutput->write(1); //turn on the relay driving digital output
        }
        
        if(this->trecord->getTemperature() > (this->defaultTemperature + 0.5*hysteresisGap)){
            this->heatingActionOn=false;        
            this->actuatorOutput->write(0); //turn off the relay driving digital output           
        }
    }
}

float thermostat::getTemperature(void){
    return this->trecord->getTemperature();
}

float thermostat::getMaxTemperature(){
    return this->trecord->getMaxTemperature();
}

float thermostat::getMinTemperature(){
    return this->trecord->getMinTemperature();
}

float thermostat::getTemperatureSetting(void){
    return this->defaultTemperature;    
}

bool thermostat::getThermostatStatus(void){
    if(this->heaterEnabled) return true;
    //defaults to false
    return false;   
}

void thermostat::ThermostatUnitTest(char *,int){
    int i;
    float testTemperatureInput[32]   =  { ;
    int expectedThermostatStatus[32] =  { ;//Expected thermostat control loop status 1 for ON,0 for Off

    for(i=0;i++;i<31){
        
    }
}