//TemperatureRecorder class
//Written by Napoleon Leoni, February 2014
//This class takes a pointer to an LM75B sensor
//and reads it temperature value, keeps track of the max and
//min values (since a last reset of the values) and also keeps 
//a circular buffer of recorded temperature values

//***************************** TESTING ********************************************************//
//  TEST        TEST DESCRIPTION                                                STATUS          //
//  1           Time display is inceremented in seconds and date shown          PASS            //
//              corresponds to date set in code                                                 //
//  2           Max temperature displayed is highest reached                    PASS            //
//              during a heating event (finger touch)                                           //
//  3           Min Temperature displayed is lowest reached                     PASS            //
//              during a cooling event                                                          //
//  4           Changing from degrees C to degress F and back retains           PASS            //
//              Max and min values and displays proper conversion                               //
//**********************************************************************************************//


#include "temperatureRecorder.h"

    //temperature Recorder class definition

    //default constructor, sets default buffer size to max
    temperatureRecorder::temperatureRecorder(){
        //set size of circular buffer for temperature history
        this->recordingBufferSize=maxRecordingBufferSize;
        this->sensorValid=false;
        this->resetTemperatureFlag=true;
    }
    
//**********************************************************************************************//
// temperatureRecorder::temperatureRecorder(int bufferSize,LM75B *ptrTsensor)                   //
// Constructor with buffer size specified and ptr to temperature sensor object                  //
// Inputs: bufferSize       integer, buffer size for circular buffer use to record temperatures //
//                          limited to max value set in MAXRECORDINGBUFFER, internally enforced //
//                          no error or warning displayed                                       //
//         *ptrTsensor      pointer to LM75B sensor object, if sensor is valid temperature      //
//                          readings can be made, otherwise the object is still created but     //
//                          temperatures are returned as zero.                                  //
//**********************************************************************************************//
    temperatureRecorder::temperatureRecorder(int bufferSize,LM75B *ptrTsensor){
        this->sensorValid=false;
        this->resetTemperatureFlag=true;
        this->externalSensor=false;
        if(bufferSize <= this->maxRecordingBufferSize){
            this->recordingBufferSize=bufferSize;
        } else {
            this->recordingBufferSize=maxRecordingBufferSize;
            //TODO return error message, but to where?
        }
        this->tsensor=ptrTsensor;
        //Check if sensor is valid
        if (this->tsensor->open()) {
            this->sensorValid=true;
            this->makeReading();
        } else {
            //TODO: how to return error condition here
        }    
    }
    
//**********************************************************************************************//
// void temperatureRecorder::makeReading(void){                                                 //
// Makes a temperature reading from the LM75B, stores the reading in the appropiate units       //
// in the object's member this->currentTemperature and updates the maxTemperature and           //  
// minTemperature                                                                               //
// Inputs: void                                                                                 //
//**********************************************************************************************//
    void temperatureRecorder::makeReading(void){
        if(this->sensorValid){
            this->currentTemperature=this->tsensor->temp();
            //check if Trecorder is set in farehnheit if so make the conversion
            if(this->temperatureInFarenheit) this->currentTemperature=convertToFarenheit(this->currentTemperature);
            //TODO store temperature into buffer
        }
            if(this->resetTemperatureFlag){
                //reset max an min values
                this->maxTemperature=this->currentTemperature;
                this->minTemperature=this->currentTemperature;
                this->resetTemperatureFlag=false;
            } else {
                //compare current temperature to stored esxtremes,replace if neccesary
                if((this->currentTemperature) > (this->maxTemperature)) this->maxTemperature=this->currentTemperature;
                if((this->currentTemperature) < (this->minTemperature)) this->minTemperature=this->currentTemperature;   
            }
    }//end of temperatureRecorder::makeReading()

//**********************************************************************************************//
// void temperatureRecorder::makeReading(float temperatureInC)                                 //
// Makes a temperature reading from an external sensor, stores the reading in the appropiate    //
// units in the object's member this->currentTemperature and updates the maxTemperature and     //  
// minTemperature                                                                               //
// Inputs: float temperatureInC, provide an external reading as opposed to the internally used  //
//         LM75B                                                                                //
//**********************************************************************************************//
void temperatureRecorder::makeReading(float temperatureInC){
            this->currentTemperature=temperatureInC;
            //check if Trecorder is set in farehnheit if so make the conversion
            if(this->temperatureInFarenheit) this->currentTemperature=convertToFarenheit(this->currentTemperature);
            //TODO store temperature into buffer
            if(this->resetTemperatureFlag){
                //reset max an min values
                this->maxTemperature=this->currentTemperature;
                this->minTemperature=this->currentTemperature;
                this->resetTemperatureFlag=false;
            } else {
                //compare current temperature to stored esxtremes,replace if neccesary
                if((this->currentTemperature) > (this->maxTemperature)) this->maxTemperature=this->currentTemperature;
                if((this->currentTemperature) < (this->minTemperature)) this->minTemperature=this->currentTemperature;   
            }
}//end of temperatureRecorder::makeReading()
    
//**********************************************************************************************//
// void temperatureRecorder::getTemperature(void){                                              //
// returns this->currentTemperature (last reading made) in the set units                        //
// if the sensor is not valid returns 0                                                         //
// Inputs: void                                                                                 //
//**********************************************************************************************//
    float temperatureRecorder::getTemperature(void){ 
        if(this->sensorValid){
            return this->currentTemperature;
        } else {
            return 0;
        }             
    }
    
//**********************************************************************************************//
// void temperatureRecorder::getMaxTemperature(void){                                           //
// returns this->maxTemperature (last reading made) in the set units                            //  
// if the sensor is not valid returns 0                                                         //
// Inputs: void                                                                                 //
//**********************************************************************************************//
    float temperatureRecorder::getMaxTemperature(void){
        if(this->sensorValid){
            return this->maxTemperature;
        } else {
            return 0;
        }             
   }
   
//**********************************************************************************************//
// void temperatureRecorder::getMinTemperature(void){                                           //
// returns this->minTemperature (last reading made) in the set units                            //  
// if the sensor is not valid returns 0                                                         //
// Inputs: void                                                                                 //
//**********************************************************************************************//
    float temperatureRecorder::getMinTemperature(void){
         if(this->sensorValid){
            return this->minTemperature;  
        } else {
            return 0;
        }             
   }
    
//**********************************************************************************************//
// void temperatureRecorder::resetTemperatureExtremes(void){                                    //
// sets an object internal flag that will trigger a reset of the Max and Min Temepratures       //  
// recorded when the next reading is made from temperature sensor                               //
// Inputs: void                                                                                 //
//**********************************************************************************************//
    void temperatureRecorder::resetTemperatureExtremes(void){
        this->resetTemperatureFlag=true;    
    }
    
//**********************************************************************************************//
// void temperatureRecorder::setTemperatureToCelsius(void){                                    //
// sets all recorded values to celsius and converts all future readings as well                //  
// Inputs: void                                                                                 //
//**********************************************************************************************//
    void temperatureRecorder::setTemperatureToCelsius(void){
        if(this->temperatureInFarenheit){
            this->temperatureInFarenheit=false;    
            this->currentTemperature=this->convertToCelsius(this->currentTemperature);
            this->maxTemperature=this->convertToCelsius(this->maxTemperature);
            this->minTemperature=this->convertToCelsius(this->minTemperature);
        }
    }

//**********************************************************************************************//
// void temperatureRecorder::setTemperatureToFarenheit(void){                                    //
// sets all recorded values to farenheit and converts all future readings as well                //  
// Inputs: void                                                                                 //
//**********************************************************************************************//
    void temperatureRecorder::setTemperatureToFarenheit(void){
        if(!this->temperatureInFarenheit){
            this->temperatureInFarenheit=true;    
            this->currentTemperature=this->convertToFarenheit(this->currentTemperature);
            this->maxTemperature=this->convertToFarenheit(this->maxTemperature);
            this->minTemperature=this->convertToFarenheit(this->minTemperature);
        }
    }
    
//**********************************************************************************************//
// void temperatureRecorder::convertToCelsius(void){                                            //
// returns a float resulting from converting farenheit to celcius                               //  
// Inputs: float Tfarenheit....Input Temperature in farenheit to be converted to Celsius        //                                                  //
//**********************************************************************************************//
    float temperatureRecorder::convertToCelsius(float Tfarenheit){
        float Tc;
        Tc=(Tfarenheit-32.0)*5.0/9.0;
        return Tc;
    }

//**********************************************************************************************//
// void temperatureRecorder::convertToFarenheit(void){                                          //
// returns a float resulting from converting celcius to farenheit                               //  
// Inputs: float Tcelsius....Input Temperature in Celsius to be converted to farenheit          //                                                  //
//**********************************************************************************************//
    float temperatureRecorder::convertToFarenheit(float Tcelsius){
        float Tf;
        Tf=(Tcelsius*9.0/5.0)+32.0;
        return Tf;
    }

//**********************************************************************************************//
// void temperatureRecorder::isTemperatureInFarenheit(void){                                    //
// returns a BOOL value which is true if the current units are farenheit otherwise false        //  
// Inputs: void                                                                                 //
//**********************************************************************************************//
    bool temperatureRecorder::isTemperatureInFarenheit(void){
        return this->temperatureInFarenheit;
    }
    
//**********************************************************************************************//
// void temperatureRecorder::enableExternalSensor(void){                                        //
// enables the external sensor mode which allows for manual setting of the temperature          //  
// Inputs: void                                                                                 //
//**********************************************************************************************//
    void temperatureRecorder::enableExternalSensor(void){
                this->externalSensor=true;
    }
    
//**********************************************************************************************//
// void temperatureRecorder::enableExternalSensor(void){                                        //
// disables the external sensor mode which allows for manual setting of the temperature          //  
// Inputs: void                                                                                 //
//**********************************************************************************************//
    void temperatureRecorder::disableExternalSensor(void){
                this->externalSensor=false;
    }

//**********************************************************************************************//
// void temperatureRecorder::inputExternalSensorTemperatureInC(float inputTemperatureInC)){     //
// sets the external sensor temperature which is what is recorded and processed when then       //
// the externalSensor flag is set to true. this enables feeding a synthetic temperature         //
// waveform for testing purposes
// Inputs: void                                                                                 //
//**********************************************************************************************//
    void temperatureRecorder::inputExternalSensorTemperatureInC(float inputTemperatureInC){
                this->externalSensorTemperatureInC=inputTemperatureInC;
    }

