#include "mbed.h"
#include "LM75B.h"

#ifndef TRECORDER
#define TRECORDER
#define MAXRECORDINGBUFFER 1024 //max size of buffer that can be specified for recording temperatures

//TemperatureRecorder class
//Written by Napoleon Leoni, February 2014
//This class takes a pointer to an LM75B sensor
//and reads it temperature value, keeps track of the max and
//min values (since a last reset of the values) and also keeps 
//a circular buffer of recorded temperature values

//***************************** TESTING ********************************************************//
//  TEST        TEST DESCRIPTION                                                STATUS          //
//  1           Time display is inceremented in seconds and date shown          PASS            //
//              corresponds to date set in code                                                 //
//  2           Max temperature displayed is highest reached                    PASS            //
//              during a heating event (finger touch)                                           //
//  3           Min Temperature displayed is lowest reached                     PASS            //
//              during a cooling event                                                          //
//  4           Changing from degrees C to degress F and back retains           PASS            //
//              Max and min values and displays proper conversion                               //
//**********************************************************************************************//


class temperatureRecorder 
{
    public:

    private:
    bool recordingEnabled,resetTemperatureFlag,sensorValid,temperatureInFarenheit,externalSensor;
    int recordingBufferSize;
    static const int maxRecordingBufferSize=MAXRECORDINGBUFFER;
    float currentTemperature,maxTemperature,minTemperature;
    LM75B *tsensor;//pointer to temperature sensor type
    float externalSensorTemperatureInC;
    
    //public Methods
    public:
    //default constructor, required
    temperatureRecorder();
    //commonly used constructor: this is the constructor that should be used.
    temperatureRecorder(int bufferSize,LM75B *ptrTsensor);
    
    void makeReading(void);
    void makeReading(float);
    
    float getTemperature(void);
    float getMaxTemperature(void);
    float getMinTemperature(void);
    
    void enableExternalSensor(void)
    void disableExternalSensor(void);
    
    void setTemperatureToCelsius(void);
    void setTemperatureToFarenheit(void);   
    bool isTemperatureInFarenheit(void);
    float convertToCelsius(float);
    float convertToFarenheit(float);

    //private Methods
    private:
    void resetTemperatureExtremes(void);
};

#endif