//joystickAppBoard class
//Written by Napoleon Leoni; February 2014
//Simple class object to handle joystick state for the mbed application board
//5 way Joystick    ALPS SKRHADE010
//Down:p12; Left:p13 Centre:p14 Up:p15 Right:p16

#include "joystickAppBoard.h"

// Joystick state definitions
//#define JOYSTICKDOWN    0x01            //0b00001  d1
//#define JOYSTICKLEFT    0x02            //0b00010  d2 
//#define JOYSTICKCENTER  0x04            //0b00100  d4
//#define JOYSTICKUP      0x08            //0b01000  d8
//#define JOYSTICKRIGHT   0x10            //0b10000  d16

//***************************** TESTING ********************************************************//
//  TEST        TEST DESCRIPTION                                                STATUS          //
//  1           getJoystickState yields the right hex value as shown above      PASS            //
//  2           Joystick posistion (up, down center, leff, right) are all       PASS            //
//              properly identified when the Joystick is actuated                               //
//**********************************************************************************************//

//**********************************************************************************************//
// void joystickAppBoard::joystickAppBoard(void){                                                 //
// Constructor, uses the predefined pins for the mbed app board to generater a BusIn object     //
// to read the joystick state
// Inputs: void                                                                                 //
//**********************************************************************************************//
  joystickAppBoard::joystickAppBoard(){
    this->joystickPins = new BusIn(p12,p13,p14,p15,p16);
    return;
  }
  
//**********************************************************************************************//
// void joystickAppBoard::readJoystick(void){                                                   //
// reads and stores the current Joystick state as defined by an integer where each bit          //
// represents one of the joystick directions                                                    //
// Inputs: void                                                                                 //
//**********************************************************************************************//
  void joystickAppBoard::readJoystick(void){
      this->joystickState=this->joystickPins->read();
  }
  
//**********************************************************************************************//
// int joystickAppBoard::getJoystickState(void){                                                //
// returns the current Joystick states as defined above                                         //
// Inputs: void                                                                                 //
//**********************************************************************************************//
  int joystickAppBoard::getJoystickState(void){
        return this->joystickState;
  }
  
//**********************************************************************************************//
// int joystickAppBoard::isJoystickUp(void){                                                    //
// returns true if Joystick is up                                                               //
// Inputs: void                                                                                 //
//**********************************************************************************************//
  bool joystickAppBoard::isJoystickUp(void){ return ( (this->joystickState) & JOYSTICKUP); }
  
//**********************************************************************************************//
// int joystickAppBoard::isJoystickDown(void){                                                  //
// returns true if Joystick is down                                                             //
// Inputs: void                                                                                 //
//**********************************************************************************************//
  bool joystickAppBoard::isJoystickDown(void){ return ( (this->joystickState) & JOYSTICKDOWN); }

//**********************************************************************************************//
// int joystickAppBoard::isJoystickLeft(void){                                                  //
// returns true if Joystick is left                                                             //
// Inputs: void                                                                                 //
//**********************************************************************************************//
  bool joystickAppBoard::isJoystickLeft(void){ return ( (this->joystickState) & JOYSTICKLEFT); }

//**********************************************************************************************//
// int joystickAppBoard::isJoystickRight(void){                                                 //
// returns true if Joystick is left                                                             //
// Inputs: void                                                                                 //
//**********************************************************************************************//
  bool joystickAppBoard::isJoystickRight(void){ return ( (this->joystickState) & JOYSTICKRIGHT); }

//**********************************************************************************************//
// int joystickAppBoard::isJoystickCenter(void){                                                //
// returns true if Joystick is center                                                           //
// Inputs: void                                                                                 //
//**********************************************************************************************//
  bool joystickAppBoard::isJoystickCenter(void){ return ( (this->joystickState) & JOYSTICKCENTER); }
