//joystickAppBoard class
//Written by Napoleon Leoni; February 2014
//Simple class object to handle joystick state for the mbed application board
//5 way Joystick    ALPS SKRHADE010
//Down:p12; Left:p13 Centre:p14 Up:p15 Right:p16

#include "mbed.h"
#include <BusIn.h>

#ifndef JOYAPPPCB
#define JOYAPPPCB
// Joystick state definitions
#define JOYSTICKDOWN    0x01            //0b00001  d1
#define JOYSTICKLEFT    0x02            //0b00010  d2 
#define JOYSTICKCENTER  0x04            //0b00100  d4
#define JOYSTICKUP      0x08            //0b01000  d8
#define JOYSTICKRIGHT   0x10            //0b10000  d16

//***************************** TESTING ********************************************************//
//  TEST        TEST DESCRIPTION                                                STATUS          //
//  1           getJoystickState yields the right hex value as shown above      PASS            //
//  2           Joystick posistion (up, down center, leff, right) are all       PASS            //
//              properly identified when the Joystick is actuated                               //
//**********************************************************************************************//

class joystickAppBoard{
  //members    
  private:
  BusIn *joystickPins;//this will be defined using all 5 pins fo joystick Busin(12,13,14,15,16)
  int joystickState;
  //methods
  
  public:
  joystickAppBoard();
  void readJoystick();
  int getJoystickState(void);
  bool isJoystickUp();
  bool isJoystickDown();
  bool isJoystickLeft();
  bool isJoystickRight();
  bool isJoystickCenter();
      
};

#endif