//***************************************************************************//
/* InterruptMask Library */
/* Napoleon Leoni, February 18,2014*/
/* This class enables masking a GPIO interrupt from a specific MBED pin      */
// Note to get the actual pin number in the LPC of an mbed pin in P0
// simply do pN-P0_0, for example p12-P0_0=17, that is pin 12 in the mbed
// corresponds to Port[0].17 or bit 17 of port 0.
//***************************************************************************//
// Example Code is in the header file: InterruptMask.h                       //
#include "InterruptMask.h"

//default constructor required, should not be use will yield error
InterruptMask::InterruptMask(void){
    exit(1);
    };

//Constructor to be used, initialize with any valid mbed pin (p5 thru p30 except pins 19-20)
//you will need one InterruptMask for every pin you want ot have control over. The constructor
//will only accept a valid pin, otherwise it will cause the prgram to exit with an error.   
InterruptMask::InterruptMask(PinName somePin){
    switch(somePin){
    case p5:
    case p6:
    case p7:
    case p8:
    case p9:
    case p10:
    case p11:
    case p12:
    case p13:
    case p14:
    case p15:
    case p16:
    case p17:
    case p18:
        //These pins are in Port 0 of the LPC1768, so the proper register is selected below
        IOIntEnF = &(LPC_GPIOINT->IO0IntEnF);
        IOIntEnR = &(LPC_GPIOINT->IO0IntEnR);
        IOIntClr = &(LPC_GPIOINT->IO0IntClr);
        this->mPin=somePin; //assign pin to internal member variable
        mask=~(1<<( (this->mPin)-P0_0));
        unmask=~mask;
        break;
    case p21:
    case p22:
    case p23:
    case p24:
    case p25:
    case p26:
    case p27:
    case p28:
    case p29:
    case p30:
        //These pins are in Port 2 of the LPC1768, so the proper register is selected below
        IOIntEnF = &(LPC_GPIOINT->IO2IntEnF);
        IOIntEnR = &(LPC_GPIOINT->IO2IntEnR);
        IOIntClr = &(LPC_GPIOINT->IO2IntClr);
        this->mPin=somePin; //assign pin to internal member variable
        mask=~(1<<( (this->mPin)-P2_0));
        unmask=~mask;
        break;
    default:
        exit(1);
    }
}

    
//This method will mask (disable) any rising edge interrupts of the specified pin
    void InterruptMask::maskIntR(void){
        (*(this->IOIntEnR)) &= this->mask;    
    }
    
    //This method will mask (disable) any faling edge interrupts of the specified pin
    void InterruptMask::maskIntF(void){
        (*(this->IOIntEnF)) &= this->mask;    
    }

    //This method will unmask (enable) any rising edge interrupts of the specified pin
    void InterruptMask::unMaskIntR(void){
        (*(this->IOIntEnR)) |= this->unmask;    
    }

    //This method will unmask (enable) any falling edge interrupts of the specified pin
    void InterruptMask::unMaskIntF(void){
        (*(this->IOIntEnF)) |= this->unmask;    
    }

    //This method will clear any pending interrupts of the specified pin
    void InterruptMask::ClrInt(void){
        (*(this->IOIntClr)) |= this->unmask;    
    }

