#include "includes.h"
#include "sensors.h"

NtcTempSensor::NtcTempSensor(PinName pin, float r_25, float ntc_b, float r_divider) {
    _in = new AnalogIn(pin);
    _ntc_b = ntc_b;
    _ntc_a = r_25 / exp(_ntc_b / 298.0f);
    _r_divider = r_divider;
}

float NtcTempSensor::GetTemp() {
    float v = (float) *_in * 3.3f;
    float r_n = v * _r_divider / (1.0f + v);
    return _ntc_b / log (r_n / _ntc_a);
}