#include "includes.h"
#include "transforms.h"
#include "fastmath.h"

void Transforms::Clarke(float a, float b, float *alpha, float *beta) {    
    *alpha = a;
    *beta = (a + 2.0f * b)/sqrt(3.0f);
}

void Transforms::InverseClarke(float alpha, float beta, float *a, float *b) {
    *a = alpha;
    *b = -0.5 * alpha + sqrt(3.0f) / 2.0f * beta;
}

void Transforms::Parke(float beta, float alpha, float theta, float *d, float *q) {
    float cos = FastCos(theta);
    float sin = FastSin(theta);
    *d = alpha * cos + beta * sin;
    *q = -alpha * sin + beta * cos;
}

void Transforms::InverseParke(float d, float q, float theta, float *alpha, float *beta) {
    float cos = FastCos(theta);
    float sin = FastSin(theta);
    *alpha = cos * d - sin * q;
    *beta = sin * d + cos * q;                                
}