#include "includes.h"
#include "transforms.h"
#include "filters.h"
#include "context.h"
#include "core.h"
#include "meta.h"
#include "sensors.h"
#include "callbacks.h"

int main() { 
    Context *context = new Context();
    context->ConfigureOutputs(D13, D3, D6, D2);
    context->ConfigureCurrentSensors(A1, A2, 0.0016f, 0.7f); //scale in V/A, filter strength
    context->ConfigureIdPidController(0.0000012f, 0.0f, 0.0f, 1.0f, -1.0f);
    context->ConfigureIqPidController(0.0000012f, 0.0f, 0.0f, 1.0f, -1.0f);
    context->ConfigureThrottle(A0, 0.9f, 2.5f, 0.99f);  //last term is LPF strength
    context->ConfigurePositionSensor(A3, A4, 0.366f, 0.655f, 0.355f, 0.626f, 260.0f); //205 is default
    context->ConfigureReference(300.0f);  // max phase current
    context->ConfigureDebugger(4, 2000);
    context->AttachCallBack(&fast, 5000);
    context->AttachCallBack(&slow, 10);
    context->AttachCallBack(&debug, 10);
    context->AttachCallBack(&log, 500);
    context->Start();
}
