#ifndef __SENSORS_H
#define __SENSORS_H

#include "includes.h"
#include "filters.h"

class CurrentSensor {
public:
    virtual float GetCurrent() {return 0.0f;}
    virtual void Zero() {}
};

class VoltageSensor {
public:
    virtual float GetVoltage() {return 0.0f;}
    virtual void Zero(){}
};

class PositionSensor {
public:
    virtual float GetPosition() {return 0.0f;}
    virtual float GetSpeed() {return 0.0f;}
};

class TempSensor {
public:
    virtual float GetTemp() {return 0.0f;}
};

class AnalogCurrentSensor: public CurrentSensor {
public:
    AnalogCurrentSensor(PinName pin, float volts_per_amp);
    virtual void Zero();
    virtual float GetCurrent();
private:
    float _zero_level, _volts_per_amp;
    AnalogIn *_in;
};

class AnalogVoltageSensor: public VoltageSensor {
public:
    AnalogVoltageSensor(PinName pin, float scale);
    virtual void Zero();
    virtual float GetVoltage();
private:
    float _zero_level, _scale;
    AnalogIn *_in;
};

class AnalogHallPositionSensor: public PositionSensor {
public:
    AnalogHallPositionSensor(PinName pin_a, PinName pin_b, float cal1_a, float cal2_a, 
                             float cal1_b, float cal2_b, float offset);
    virtual float GetPosition();
    virtual float GetSpeed() {return _speed * 1000000.0f / 360.0f;}
private:
    void upd_function() {_time += 50;}
    float _cal1_a, _cal2_a;
    float _cal1_b, _cal2_b;
    float _offset;
    AnalogIn *_in_a, *_in_b;
private:
    Ticker *_time_upd_ticker;
    unsigned long _time;
    float _last_time, _last_position, _speed;
};

class NtcTempSensor: public TempSensor {
public:
    NtcTempSensor(PinName pin, float r_25, float ntc_b, float r_divider);
    virtual float GetTemp();
private:
    float _ntc_a, _ntc_b, _r_divider;
    AnalogIn *_in;
};

class Throttle {
public:
    Throttle(PinName pin, float min, float max);
    float GetThrottle();
private:
    float _min, _max;
    VoltageSensor *_in;
};

#endif