#ifndef __CORE_H
#define __CORE_H

#include "includes.h"
#include "sensors.h"

class Motor;
class Inverter;
class CurrentSensor;
class VoltageSensor;
class PositionSensor;
class TempSensor;

class Motor {
public:
    Motor(CurrentSensor *sense_c, CurrentSensor *sense_b, PositionSensor *sense_p, TempSensor *sense_t);
    void Config(int num_poles, float kv);
    float GetCurrentC();
    float GetCurrentB();
    float GetPosition();
    float GetSpeed();
    float GetTemp();
private:
    CurrentSensor *_sense_c,*_sense_b;
    PositionSensor *_sense_p;
    TempSensor *_sense_t;
    int _num_poles;
    float _kv;
};

class Inverter {
public:
    Inverter(PinName ph_a, PinName ph_b, PinName ph_c, PinName en, VoltageSensor *sense_bus, TempSensor *sense_t);
    void SetDtcA(float dtc);
    void SetDtcB(float dtc);
    void SetDtcC(float dtc);
    void Disable();
    void Enable();
    float GetVbus();
    float GetTemp();
private:
    PwmOut *_pwm_a, *_pwm_b, *_pwm_c;
    DigitalOut *_en;
    VoltageSensor *_sense_bus;
    TempSensor *_sense_t;
};

class User {
public:
    User(Throttle *throttle) {_throttle = throttle;}
    void UpdateThrottle() {throttle = _throttle->GetThrottle();} 
public:
    float throttle;
private:
    Throttle *_throttle;
};

#endif