#include "includes.h"
#include "sensors.h"

AnalogVoltageSensor::AnalogVoltageSensor(PinName pin, float scale) {
    _in = new AnalogIn(pin);
    _scale = scale;
}

void AnalogVoltageSensor::Zero() {
    _zero_level = (float) *_in;
}

float AnalogVoltageSensor::GetVoltage() {
    return ((float) *_in - _zero_level) * 3.3f / _scale;
}