#include "includes.h"
#include "core.h"
#include "sensors.h"

Motor::Motor(CurrentSensor *sense_c, CurrentSensor *sense_b, PositionSensor *sense_p, TempSensor *sense_t) {
    _sense_c = sense_c;
    _sense_b = sense_b;
    _sense_p = sense_p;
    _sense_t = sense_t;
}

float Motor::GetCurrentC() {
    return _sense_c->GetCurrent();
}

float Motor::GetCurrentB() {
    return _sense_b->GetCurrent();
}

float Motor::GetPosition() {
    return _sense_p->GetPosition();
}

float Motor::GetTemp() {
    return _sense_t->GetTemp();
}

void Motor::Config(int num_poles, float kv) {
    _num_poles = num_poles;
    _kv = kv;
}